/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;

public final class AMQPFederationConfiguration {
    public static final int DEFAULT_LINK_ATTACH_TIMEOUT = 30;
    public static final boolean DEFAULT_CORE_MESSAGE_TUNNELING_ENABLED = true;
    private final Map<String, Object> properties;
    private final AMQPConnectionContext connection;

    public AMQPFederationConfiguration(AMQPConnectionContext connection, Map<String, Object> properties) {
        Objects.requireNonNull(connection, "Connection provided cannot be null");
        this.connection = connection;
        this.properties = properties != null && !properties.isEmpty() ? new HashMap<String, Object>(properties) : Collections.EMPTY_MAP;
    }

    public int getReceiverCredits() {
        Object property = this.properties.get("amqpCredits");
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return Integer.parseInt((String)property);
        }
        return this.connection.getAmqpCredits();
    }

    public int getReceiverCreditsLow() {
        Object property = this.properties.get("amqpLowCredits");
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return Integer.parseInt((String)property);
        }
        return this.connection.getAmqpLowCredits();
    }

    public int getLargeMessageThreshold() {
        Object property = this.properties.get("minLargeMessageSize");
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return Integer.parseInt((String)property);
        }
        return this.connection.getProtocolManager().getAmqpMinLargeMessageSize();
    }

    public int getLinkAttachTimeout() {
        Object property = this.properties.get("attach-timeout");
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return Integer.parseInt((String)property);
        }
        return 30;
    }

    public boolean isCoreMessageTunnelingEnabled() {
        Object property = this.properties.get("tunnel-core-messages");
        if (property instanceof Boolean) {
            return (Boolean)property;
        }
        if (property instanceof String) {
            return Boolean.parseBoolean((String)property);
        }
        return true;
    }

    public Map<String, Object> toConfigurationMap() {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put("amqpCredits", this.getReceiverCredits());
        configMap.put("amqpLowCredits", this.getReceiverCreditsLow());
        configMap.put("minLargeMessageSize", this.getLargeMessageThreshold());
        configMap.put("attach-timeout", this.getLinkAttachTimeout());
        configMap.put("tunnel-core-messages", this.isCoreMessageTunnelingEnabled());
        return configMap;
    }
}

