/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.logger;

import java.util.Arrays;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPIllegalStateException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInternalErrorException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInvalidFieldException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPNotFoundException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPSecurityException;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolMessageBundle;
import org.slf4j.Logger;
import org.slf4j.helpers.MessageFormatter;

public class ActiveMQAMQPProtocolMessageBundle_impl
implements ActiveMQAMQPProtocolMessageBundle {
    private final Logger logger;

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    public ActiveMQAMQPProtocolMessageBundle_impl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public ActiveMQAMQPInvalidFieldException targetAddressNotSet() {
        String returnString = "AMQ119000: target address not set";
        ActiveMQAMQPInvalidFieldException objReturn_targetAddressNotSet = new ActiveMQAMQPInvalidFieldException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_targetAddressNotSet));
        return objReturn_targetAddressNotSet;
    }

    @Override
    public ActiveMQAMQPInternalErrorException errorCreatingTemporaryQueue(String message) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ119001: error creating temporary queue, {}", (Object[])new Object[]{message}).getMessage();
        ActiveMQAMQPInternalErrorException objReturn_errorCreatingTemporaryQueue = new ActiveMQAMQPInternalErrorException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_errorCreatingTemporaryQueue));
        return objReturn_errorCreatingTemporaryQueue;
    }

    @Override
    public ActiveMQAMQPNotFoundException addressDoesntExist() {
        String returnString = "AMQ119002: target address does not exist";
        ActiveMQAMQPNotFoundException objReturn_addressDoesntExist = new ActiveMQAMQPNotFoundException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_addressDoesntExist));
        return objReturn_addressDoesntExist;
    }

    @Override
    public ActiveMQAMQPNotFoundException errorFindingTemporaryQueue(String message) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ119003: error finding temporary queue, {}", (Object[])new Object[]{message}).getMessage();
        ActiveMQAMQPNotFoundException objReturn_errorFindingTemporaryQueue = new ActiveMQAMQPNotFoundException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_errorFindingTemporaryQueue));
        return objReturn_errorFindingTemporaryQueue;
    }

    @Override
    public ActiveMQAMQPInternalErrorException errorCreatingConsumer(String message) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ119005: error creating consumer, {}", (Object[])new Object[]{message}).getMessage();
        ActiveMQAMQPInternalErrorException objReturn_errorCreatingConsumer = new ActiveMQAMQPInternalErrorException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_errorCreatingConsumer));
        return objReturn_errorCreatingConsumer;
    }

    @Override
    public ActiveMQAMQPIllegalStateException errorStartingConsumer(String message) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ119006: error starting consumer, {}", (Object[])new Object[]{message}).getMessage();
        ActiveMQAMQPIllegalStateException objReturn_errorStartingConsumer = new ActiveMQAMQPIllegalStateException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_errorStartingConsumer));
        return objReturn_errorStartingConsumer;
    }

    @Override
    public ActiveMQAMQPIllegalStateException errorAcknowledgingMessage(String messageID, String message) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ119007: error acknowledging message {}, {}", (Object[])new Object[]{messageID, message}).getMessage();
        ActiveMQAMQPIllegalStateException objReturn_errorAcknowledgingMessage = new ActiveMQAMQPIllegalStateException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_errorAcknowledgingMessage));
        return objReturn_errorAcknowledgingMessage;
    }

    @Override
    public ActiveMQAMQPIllegalStateException errorCancellingMessage(String messageID, String message) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ119008: error cancelling message {}, {}", (Object[])new Object[]{messageID, message}).getMessage();
        ActiveMQAMQPIllegalStateException objReturn_errorCancellingMessage = new ActiveMQAMQPIllegalStateException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_errorCancellingMessage));
        return objReturn_errorCancellingMessage;
    }

    @Override
    public ActiveMQAMQPNotFoundException sourceAddressDoesntExist() {
        String returnString = "AMQ119010: source address does not exist";
        ActiveMQAMQPNotFoundException objReturn_sourceAddressDoesntExist = new ActiveMQAMQPNotFoundException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_sourceAddressDoesntExist));
        return objReturn_sourceAddressDoesntExist;
    }

    @Override
    public ActiveMQAMQPInvalidFieldException sourceAddressNotSet() {
        String returnString = "AMQ119011: source address not set";
        ActiveMQAMQPInvalidFieldException objReturn_sourceAddressNotSet = new ActiveMQAMQPInvalidFieldException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_sourceAddressNotSet));
        return objReturn_sourceAddressNotSet;
    }

    @Override
    public ActiveMQAMQPIllegalStateException errorRollingbackCoordinator(String message) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ119012: error rolling back coordinator: {}", (Object[])new Object[]{message}).getMessage();
        ActiveMQAMQPIllegalStateException objReturn_errorRollingbackCoordinator = new ActiveMQAMQPIllegalStateException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_errorRollingbackCoordinator));
        return objReturn_errorRollingbackCoordinator;
    }

    @Override
    public ActiveMQAMQPIllegalStateException errorCommittingCoordinator(String message) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ119013: error committing coordinator: {}", (Object[])new Object[]{message}).getMessage();
        ActiveMQAMQPIllegalStateException objReturn_errorCommittingCoordinator = new ActiveMQAMQPIllegalStateException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_errorCommittingCoordinator));
        return objReturn_errorCommittingCoordinator;
    }

    @Override
    public ActiveMQAMQPIllegalStateException txNotFound(String xidToString) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ119014: Transaction not found: xid={}", (Object[])new Object[]{xidToString}).getMessage();
        ActiveMQAMQPIllegalStateException objReturn_txNotFound = new ActiveMQAMQPIllegalStateException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_txNotFound));
        return objReturn_txNotFound;
    }

    @Override
    public ActiveMQAMQPSecurityException securityErrorCreatingConsumer(String message) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ119015: not authorized to create consumer, {}", (Object[])new Object[]{message}).getMessage();
        ActiveMQAMQPSecurityException objReturn_securityErrorCreatingConsumer = new ActiveMQAMQPSecurityException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_securityErrorCreatingConsumer));
        return objReturn_securityErrorCreatingConsumer;
    }

    @Override
    public ActiveMQAMQPSecurityException securityErrorCreatingTempDestination(String message) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ119016: not authorized to create temporary destination, {}", (Object[])new Object[]{message}).getMessage();
        ActiveMQAMQPSecurityException objReturn_securityErrorCreatingTempDestination = new ActiveMQAMQPSecurityException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_securityErrorCreatingTempDestination));
        return objReturn_securityErrorCreatingTempDestination;
    }

    @Override
    public ActiveMQAMQPSecurityException securityErrorCreatingProducer(String message) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ119017: not authorized to create producer, {}", (Object[])new Object[]{message}).getMessage();
        ActiveMQAMQPSecurityException objReturn_securityErrorCreatingProducer = new ActiveMQAMQPSecurityException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_securityErrorCreatingProducer));
        return objReturn_securityErrorCreatingProducer;
    }

    @Override
    public ActiveMQAMQPIllegalStateException missingOfferedCapability(String capability) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ119018: link is missing an offered capability declaration {}", (Object[])new Object[]{capability}).getMessage();
        ActiveMQAMQPIllegalStateException objReturn_missingOfferedCapability = new ActiveMQAMQPIllegalStateException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_missingOfferedCapability));
        return objReturn_missingOfferedCapability;
    }

    @Override
    public ActiveMQAMQPIllegalStateException missingBrokerID() {
        String returnString = "AMQ119019: There is no brokerID defined on the target connection. Connection will be closed.";
        ActiveMQAMQPIllegalStateException objReturn_missingBrokerID = new ActiveMQAMQPIllegalStateException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_missingBrokerID));
        return objReturn_missingBrokerID;
    }

    @Override
    public ActiveMQAMQPIllegalStateException brokerConnectionTimeout() {
        String returnString = "AMQ119020: The Broker Connection Open Callback Has Timed Out.";
        ActiveMQAMQPIllegalStateException objReturn_brokerConnectionTimeout = new ActiveMQAMQPIllegalStateException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_brokerConnectionTimeout));
        return objReturn_brokerConnectionTimeout;
    }

    @Override
    public ActiveMQAMQPIllegalStateException brokerConnectionRemoteLinkClosed() {
        String returnString = "AMQ119021: The broker connection had a remote link closed unexpectedly";
        ActiveMQAMQPIllegalStateException objReturn_brokerConnectionRemoteLinkClosed = new ActiveMQAMQPIllegalStateException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_brokerConnectionRemoteLinkClosed));
        return objReturn_brokerConnectionRemoteLinkClosed;
    }

    @Override
    public ActiveMQAMQPIllegalStateException brokerConnectionMirrorItself() {
        String returnString = "AMQ119022: The broker connection is trying to connect to itself. Check your configuration.";
        ActiveMQAMQPIllegalStateException objReturn_brokerConnectionMirrorItself = new ActiveMQAMQPIllegalStateException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_brokerConnectionMirrorItself));
        return objReturn_brokerConnectionMirrorItself;
    }

    @Override
    public ActiveMQAMQPIllegalStateException senderLinkRefused(String address) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ119023: Sender link refused for address {}", (Object[])new Object[]{address}).getMessage();
        ActiveMQAMQPIllegalStateException objReturn_senderLinkRefused = new ActiveMQAMQPIllegalStateException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_senderLinkRefused));
        return objReturn_senderLinkRefused;
    }

    @Override
    public ActiveMQAMQPIllegalStateException missingDesiredCapability(String capability) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ119024: link is missing a desired capability declaration {}", (Object[])new Object[]{capability}).getMessage();
        ActiveMQAMQPIllegalStateException objReturn_missingDesiredCapability = new ActiveMQAMQPIllegalStateException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_missingDesiredCapability));
        return objReturn_missingDesiredCapability;
    }
}

