/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.sasl.scram;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.protocol.amqp.broker.AmqpInterceptor;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManager;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPRedirectHandler;
import org.apache.activemq.artemis.protocol.amqp.sasl.ServerSASL;
import org.apache.activemq.artemis.protocol.amqp.sasl.ServerSASLFactory;
import org.apache.activemq.artemis.protocol.amqp.sasl.scram.SCRAMServerSASL;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManager;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.security.jaas.DigestCallback;
import org.apache.activemq.artemis.spi.core.security.jaas.HmacCallback;
import org.apache.activemq.artemis.spi.core.security.jaas.SCRAMMechanismCallback;
import org.apache.activemq.artemis.spi.core.security.scram.SCRAM;
import org.apache.activemq.artemis.spi.core.security.scram.UserData;
import org.jboss.logging.Logger;

public abstract class SCRAMServerSASLFactory
implements ServerSASLFactory {
    private final Logger logger = Logger.getLogger(this.getClass());
    private final SCRAM scramType;

    public SCRAMServerSASLFactory(SCRAM scram) {
        this.scramType = scram;
    }

    @Override
    public String getMechanism() {
        return this.scramType.getName();
    }

    @Override
    public boolean isDefaultPermitted() {
        return false;
    }

    @Override
    public ServerSASL create(ActiveMQServer server, ProtocolManager<AmqpInterceptor, AMQPRedirectHandler> manager, Connection connection, RemotingConnection remotingConnection) {
        try {
            if (manager instanceof ProtonProtocolManager) {
                String loginConfigScope = ((ProtonProtocolManager)manager).getSaslLoginConfigScope();
                return new JAASSCRAMServerSASL(this.scramType, loginConfigScope, this.logger);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return null;
    }

    private static final class JAASSCRAMServerSASL
    extends SCRAMServerSASL {
        private final String loginConfigScope;
        private LoginContext loginContext = null;
        private Subject loginSubject;
        private final Logger logger;

        JAASSCRAMServerSASL(SCRAM scram, String loginConfigScope, Logger logger2) throws NoSuchAlgorithmException {
            super(scram);
            this.loginConfigScope = loginConfigScope;
            this.logger = logger2;
        }

        @Override
        protected UserData aquireUserData(final String userName) throws LoginException {
            this.loginContext = new LoginContext(this.loginConfigScope, new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    for (Callback callback : callbacks) {
                        if (callback instanceof NameCallback) {
                            ((NameCallback)callback).setName(userName);
                            continue;
                        }
                        if (callback instanceof SCRAMMechanismCallback) {
                            ((SCRAMMechanismCallback)callback).setMechanism(mechanism.getName());
                            continue;
                        }
                        if (callback instanceof DigestCallback) {
                            ((DigestCallback)callback).setDigest(scram.getDigest());
                            continue;
                        }
                        if (callback instanceof HmacCallback) {
                            ((HmacCallback)callback).setHmac(scram.getHmac());
                            continue;
                        }
                        throw new UnsupportedCallbackException(callback, "Unrecognized Callback " + callback.getClass().getSimpleName());
                    }
                }
            });
            this.loginContext.login();
            this.loginSubject = this.loginContext.getSubject();
            Iterator<UserData> credentials = this.loginSubject.getPublicCredentials(UserData.class).iterator();
            if (credentials.hasNext()) {
                return credentials.next();
            }
            throw new LoginException("can't aquire user data through configured login config scope (" + this.loginConfigScope + ")");
        }

        @Override
        protected Subject createSaslSubject(String userName, UserData userData) {
            if (this.loginSubject != null) {
                return new Subject(true, this.loginSubject.getPrincipals(), this.loginSubject.getPublicCredentials(), this.loginSubject.getPrivateCredentials());
            }
            return super.createSaslSubject(userName, userData);
        }

        @Override
        public void done() {
            if (this.loginContext != null) {
                try {
                    this.loginContext.logout();
                }
                catch (LoginException loginException) {
                    // empty catch block
                }
            }
            this.loginContext = null;
            this.loginSubject = null;
        }

        @Override
        protected void failed(Exception e) {
            this.logger.warn((Object)"SASL-SCRAM Authentication failed", (Throwable)e);
        }
    }
}

