/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.broker;

import io.netty.channel.ChannelPipeline;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyServerConnection;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.server.management.NotificationListener;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPConnectionCallback;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.ActiveMQProtonRemotingConnection;
import org.apache.activemq.artemis.protocol.amqp.broker.AmqpInterceptor;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManagerFactory;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.sasl.MechanismFinder;
import org.apache.activemq.artemis.spi.core.protocol.AbstractProtocolManager;
import org.apache.activemq.artemis.spi.core.protocol.ConnectionEntry;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Acceptor;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.jboss.logging.Logger;

public class ProtonProtocolManager
extends AbstractProtocolManager<AMQPMessage, AmqpInterceptor, ActiveMQProtonRemotingConnection>
implements NotificationListener {
    private static final Logger logger = Logger.getLogger(ProtonProtocolManager.class);
    private static final List<String> websocketRegistryNames = Arrays.asList("amqp");
    private final List<AmqpInterceptor> incomingInterceptors = new ArrayList<AmqpInterceptor>();
    private final List<AmqpInterceptor> outgoingInterceptors = new ArrayList<AmqpInterceptor>();
    private final ActiveMQServer server;
    private final ProtonProtocolManagerFactory factory;
    private final Map<SimpleString, RoutingType> prefixes = new HashMap<SimpleString, RoutingType>();
    private int amqpMinLargeMessageSize = 102400;
    private int amqpCredits = 1000;
    private int amqpLowCredits = 300;
    private boolean amqpDuplicateDetection = true;
    private boolean amqpUseModifiedForTransientDeliveryErrors = false;
    private boolean amqpTreatRejectAsUnmodifiedDeliveryFailed = false;
    private int initialRemoteMaxFrameSize = 4096;
    private String[] saslMechanisms = MechanismFinder.getKnownMechanisms();
    private String saslLoginConfigScope = "amqp-sasl-gssapi";
    private Long amqpIdleTimeout;
    private boolean directDeliver = true;
    private String pubSubPrefix = "topic://";
    private int maxFrameSize = 131072;

    public ProtonProtocolManager(ProtonProtocolManagerFactory factory, ActiveMQServer server, List<BaseInterceptor> incomingInterceptors, List<BaseInterceptor> outgoingInterceptors) {
        this.factory = factory;
        this.server = server;
        this.updateInterceptors(incomingInterceptors, outgoingInterceptors);
    }

    public ActiveMQServer getServer() {
        return this.server;
    }

    public void onNotification(Notification notification) {
    }

    public int getAmqpMinLargeMessageSize() {
        return this.amqpMinLargeMessageSize;
    }

    public ProtonProtocolManager setAmqpMinLargeMessageSize(int amqpMinLargeMessageSize) {
        this.amqpMinLargeMessageSize = amqpMinLargeMessageSize;
        return this;
    }

    public boolean isAmqpDuplicateDetection() {
        return this.amqpDuplicateDetection;
    }

    public ProtonProtocolManager setAmqpDuplicateDetection(boolean duplicateDetection) {
        this.amqpDuplicateDetection = duplicateDetection;
        return this;
    }

    public ProtocolManagerFactory<AmqpInterceptor> getFactory() {
        return this.factory;
    }

    public void updateInterceptors(List incoming, List outgoing) {
        this.incomingInterceptors.clear();
        this.incomingInterceptors.addAll(this.getFactory().filterInterceptors(incoming));
        this.outgoingInterceptors.clear();
        this.outgoingInterceptors.addAll(this.getFactory().filterInterceptors(outgoing));
    }

    public boolean acceptsNoHandshake() {
        return false;
    }

    public Long getAmqpIdleTimeout() {
        return this.amqpIdleTimeout;
    }

    public ProtonProtocolManager setAmqpIdleTimeout(Long ttl) {
        logger.debug((Object)("Setting up " + ttl + " as the connectionTtl"));
        this.amqpIdleTimeout = ttl;
        return this;
    }

    public boolean isDirectDeliver() {
        return this.directDeliver;
    }

    public ProtonProtocolManager setDirectDeliver(boolean directDeliver) {
        this.directDeliver = directDeliver;
        return this;
    }

    public ConnectionEntry createConnectionEntry(Acceptor acceptorUsed, Connection remotingConnection) {
        AMQPConnectionCallback connectionCallback = new AMQPConnectionCallback(this, remotingConnection, (Executor)this.server.getExecutorFactory().getExecutor(), this.server);
        long ttl = ActiveMQClient.DEFAULT_CONNECTION_TTL;
        if (this.server.getConfiguration().getConnectionTTLOverride() != -1L) {
            ttl = this.server.getConfiguration().getConnectionTTLOverride();
        }
        if (this.getAmqpIdleTimeout() != null) {
            ttl = this.getAmqpIdleTimeout();
        }
        if (ttl < 0L) {
            ttl = 0L;
        }
        String id = this.server.getConfiguration().getName();
        boolean useCoreSubscriptionNaming = this.server.getConfiguration().isAmqpUseCoreSubscriptionNaming();
        AMQPConnectionContext amqpConnection = new AMQPConnectionContext(this, connectionCallback, id, (int)ttl, this.getMaxFrameSize(), 65535, useCoreSubscriptionNaming, this.server.getScheduledPool(), true, null, null);
        ArtemisExecutor executor = this.server.getExecutorFactory().getExecutor();
        ActiveMQProtonRemotingConnection delegate = new ActiveMQProtonRemotingConnection(this, amqpConnection, remotingConnection, (Executor)executor);
        delegate.addFailureListener(connectionCallback);
        delegate.addCloseListener(connectionCallback);
        connectionCallback.setProtonConnectionDelegate(delegate);
        ConnectionEntry entry = new ConnectionEntry((RemotingConnection)delegate, (Executor)executor, System.currentTimeMillis(), ttl <= 0L ? -1L : ttl);
        return entry;
    }

    public void removeHandler(String name) {
    }

    public void handleBuffer(RemotingConnection connection, ActiveMQBuffer buffer) {
        ActiveMQProtonRemotingConnection protonConnection = (ActiveMQProtonRemotingConnection)connection;
        protonConnection.bufferReceived(protonConnection.getID(), buffer);
    }

    public void addChannelHandlers(ChannelPipeline pipeline) {
    }

    public int getAmqpCredits() {
        return this.amqpCredits;
    }

    public ProtonProtocolManager setAmqpCredits(int amqpCredits) {
        this.amqpCredits = amqpCredits;
        return this;
    }

    public int getAmqpLowCredits() {
        return this.amqpLowCredits;
    }

    public ProtonProtocolManager setAmqpLowCredits(int amqpLowCredits) {
        this.amqpLowCredits = amqpLowCredits;
        return this;
    }

    public boolean isProtocol(byte[] array) {
        return array.length >= 4 && array[0] == 65 && array[1] == 77 && array[2] == 81 && array[3] == 80;
    }

    public void handshake(NettyServerConnection connection, ActiveMQBuffer buffer) {
    }

    public List<String> websocketSubprotocolIdentifiers() {
        return websocketRegistryNames;
    }

    public String getPubSubPrefix() {
        return this.pubSubPrefix;
    }

    public void setPubSubPrefix(String pubSubPrefix) {
        this.pubSubPrefix = pubSubPrefix;
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public void setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    public String[] getSaslMechanisms() {
        return this.saslMechanisms;
    }

    public void setSaslMechanisms(String[] saslMechanisms) {
        this.saslMechanisms = saslMechanisms;
    }

    public String getSaslLoginConfigScope() {
        return this.saslLoginConfigScope;
    }

    public void setSaslLoginConfigScope(String saslLoginConfigScope) {
        this.saslLoginConfigScope = saslLoginConfigScope;
    }

    public void setAnycastPrefix(String anycastPrefix) {
        for (String prefix : anycastPrefix.split(",")) {
            this.prefixes.put(SimpleString.toSimpleString((String)prefix), RoutingType.ANYCAST);
        }
    }

    public void setMulticastPrefix(String multicastPrefix) {
        for (String prefix : multicastPrefix.split(",")) {
            this.prefixes.put(SimpleString.toSimpleString((String)prefix), RoutingType.MULTICAST);
        }
    }

    public Map<SimpleString, RoutingType> getPrefixes() {
        return this.prefixes;
    }

    public String invokeIncoming(AMQPMessage message, ActiveMQProtonRemotingConnection connection) {
        return super.invokeInterceptors(this.incomingInterceptors, (Object)message, (RemotingConnection)connection);
    }

    public String invokeOutgoing(AMQPMessage message, ActiveMQProtonRemotingConnection connection) {
        return super.invokeInterceptors(this.outgoingInterceptors, (Object)message, (RemotingConnection)connection);
    }

    public int getInitialRemoteMaxFrameSize() {
        return this.initialRemoteMaxFrameSize;
    }

    public void setInitialRemoteMaxFrameSize(int initialRemoteMaxFrameSize) {
        this.initialRemoteMaxFrameSize = initialRemoteMaxFrameSize;
    }

    public boolean isUseModifiedForTransientDeliveryErrors() {
        return this.amqpUseModifiedForTransientDeliveryErrors;
    }

    public ProtonProtocolManager setAmqpUseModifiedForTransientDeliveryErrors(boolean amqpUseModifiedForTransientDeliveryErrors) {
        this.amqpUseModifiedForTransientDeliveryErrors = amqpUseModifiedForTransientDeliveryErrors;
        return this;
    }

    public void setAmqpTreatRejectAsUnmodifiedDeliveryFailed(boolean amqpTreatRejectAsUnmodifiedDeliveryFailed) {
        this.amqpTreatRejectAsUnmodifiedDeliveryFailed = amqpTreatRejectAsUnmodifiedDeliveryFailed;
    }

    public boolean isAmqpTreatRejectAsUnmodifiedDeliveryFailed() {
        return this.amqpTreatRejectAsUnmodifiedDeliveryFailed;
    }
}

