/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.broker;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import org.apache.activemq.artemis.protocol.amqp.broker.KMPNeedle;
import org.apache.activemq.artemis.protocol.amqp.util.TLSEncode;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Footer;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.TypeConstructor;

final class AMQPMessageSymbolSearch {
    private static final IdentityHashMap<Class<?>, Boolean> MSG_BODY_TYPES;

    AMQPMessageSymbolSearch() {
    }

    public static KMPNeedle kmpNeedleOf(Symbol symbol) {
        return KMPNeedle.of(symbol.toString().getBytes(StandardCharsets.US_ASCII));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean anyMessageAnnotations(ReadableBuffer data, KMPNeedle[] needles) {
        DecoderImpl decoder = TLSEncode.getDecoder();
        int position = data.position();
        decoder.setBuffer(data.rewind());
        try {
            while (data.hasRemaining()) {
                TypeConstructor constructor = decoder.readConstructor();
                Class typeClass = constructor.getTypeClass();
                if (MSG_BODY_TYPES.containsKey(typeClass)) {
                    if (MessageAnnotations.class.equals((Object)typeClass)) {
                        int start = data.position();
                        constructor.skipValue();
                        int end = data.position();
                        int count = needles.length;
                        for (int i = 0; i < count; ++i) {
                            int foundIndex = needles[i].searchInto(data, start, end);
                            if (foundIndex == -1) continue;
                            boolean bl = true;
                            return bl;
                        }
                    }
                    boolean bl = false;
                    return bl;
                }
                constructor.skipValue();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            decoder.setBuffer(null);
            data.position(position);
        }
    }

    static {
        List<Class> classList = Arrays.asList(MessageAnnotations.class, Properties.class, ApplicationProperties.class, Data.class, AmqpSequence.class, AmqpValue.class, Footer.class);
        MSG_BODY_TYPES = new IdentityHashMap(classList.size());
        classList.forEach(clazz -> MSG_BODY_TYPES.put((Class<?>)clazz, Boolean.TRUE));
    }
}

