/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.broker;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.persistence.CoreMessageObjectPools;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessagePersister;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPStandardMessage;
import org.apache.activemq.artemis.utils.collections.TypedProperties;

public class AMQPMessagePersisterV2
extends AMQPMessagePersister {
    public static final byte ID = 3;
    public static AMQPMessagePersisterV2 theInstance;

    public static AMQPMessagePersisterV2 getInstance() {
        if (theInstance == null) {
            theInstance = new AMQPMessagePersisterV2();
        }
        return theInstance;
    }

    @Override
    public byte getID() {
        return 3;
    }

    @Override
    public int getEncodeSize(Message record) {
        int encodeSize = super.getEncodeSize(record) + 4;
        TypedProperties properties = ((AMQPMessage)record).getExtraProperties();
        return encodeSize + (properties != null ? properties.getEncodeSize() : 0);
    }

    @Override
    public void encode(ActiveMQBuffer buffer, Message record) {
        super.encode(buffer, record);
        TypedProperties properties = ((AMQPMessage)record).getExtraProperties();
        if (properties == null) {
            buffer.writeInt(0);
        } else {
            buffer.writeInt(properties.getEncodeSize());
            properties.encode(buffer.byteBuf());
        }
    }

    @Override
    public Message decode(ActiveMQBuffer buffer, Message ignore, CoreMessageObjectPools pool) {
        long id = buffer.readLong();
        long format = buffer.readLong();
        SimpleString address = pool == null ? buffer.readNullableSimpleString() : SimpleString.readNullableSimpleString((ByteBuf)buffer.byteBuf(), (SimpleString.ByteBufSimpleStringPool)pool.getAddressDecoderPool());
        AMQPStandardMessage record = new AMQPStandardMessage(format);
        record.reloadPersistence(buffer, pool);
        record.setMessageID(id);
        int size = buffer.readInt();
        if (size != 0) {
            TypedProperties extraProperties = record.createExtraProperties();
            extraProperties.decode(buffer.byteBuf(), pool != null ? pool.getPropertiesDecoderPools() : null);
            assert (Objects.equals(address, extraProperties.getSimpleStringProperty(AMQPMessage.ADDRESS_PROPERTY))) : "AMQPMessage address and extraProperties address should match";
        } else if (address != null) {
            record.setAddress(address);
        }
        return record;
    }
}

