/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.activemq.console.filter.AbstractQueryFilter;
import org.apache.activemq.console.filter.QueryFilter;

public abstract class RegExQueryFilter
extends AbstractQueryFilter {
    public static final String REGEX_PREFIX = "REGEX:QUERY:";

    protected RegExQueryFilter(QueryFilter next) {
        super(next);
    }

    @Override
    public List query(List queries) throws Exception {
        HashMap<String, Pattern> regex = new HashMap<String, Pattern>();
        ArrayList<String> newQueries = new ArrayList<String>();
        for (String token : queries) {
            String key = "";
            String val = "";
            int pos = token.indexOf("=");
            if (pos >= 0) {
                val = token.substring(pos + 1);
                key = token.substring(0, pos);
            }
            if (this.isRegularExpression(val)) {
                regex.put(key, this.compileQuery(val));
                continue;
            }
            newQueries.add(token);
        }
        return this.filterCollectionUsingRegEx(regex, this.next.query(newQueries));
    }

    protected boolean isRegularExpression(String query) {
        return query.startsWith(REGEX_PREFIX);
    }

    protected Pattern compileQuery(String query) {
        return Pattern.compile(query.substring(REGEX_PREFIX.length()));
    }

    protected List filterCollectionUsingRegEx(Map regex, List data) throws Exception {
        if (regex == null || regex.isEmpty()) {
            return data;
        }
        ArrayList filteredElems = new ArrayList();
        for (Object dataElem : data) {
            if (!this.matches(dataElem, regex)) continue;
            filteredElems.add(dataElem);
        }
        return filteredElems;
    }

    protected abstract boolean matches(Object var1, Map var2) throws Exception;
}

