/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Message;
import org.apache.camel.Ordered;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.spi.SynchronizationRouteAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.SynchronizationAdapter;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnCompletionProcessor
extends AsyncProcessorSupport
implements Traceable,
IdAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(OnCompletionProcessor.class);
    private final CamelContext camelContext;
    private String id;
    private String routeId;
    private final Processor processor;
    private final ExecutorService executorService;
    private final boolean shutdownExecutorService;
    private final boolean onCompleteOnly;
    private final boolean onFailureOnly;
    private final Predicate onWhen;
    private final boolean useOriginalBody;
    private final boolean afterConsumer;
    private final boolean routeScoped;

    public OnCompletionProcessor(CamelContext camelContext, Processor processor, ExecutorService executorService, boolean shutdownExecutorService, boolean onCompleteOnly, boolean onFailureOnly, Predicate onWhen, boolean useOriginalBody, boolean afterConsumer, boolean routeScoped) {
        ObjectHelper.notNull((Object)camelContext, (String)"camelContext");
        ObjectHelper.notNull((Object)processor, (String)"processor");
        this.camelContext = camelContext;
        this.processor = processor;
        this.executorService = executorService;
        this.shutdownExecutorService = shutdownExecutorService;
        this.onCompleteOnly = onCompleteOnly;
        this.onFailureOnly = onFailureOnly;
        this.onWhen = onWhen;
        this.useOriginalBody = useOriginalBody;
        this.afterConsumer = afterConsumer;
        this.routeScoped = routeScoped;
    }

    protected void doBuild() throws Exception {
        ServiceHelper.buildService((Object)this.processor);
    }

    protected void doInit() throws Exception {
        ServiceHelper.initService((Object)this.processor);
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService((Object)this.processor);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.processor);
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownService((Object)this.processor);
        if (this.shutdownExecutorService) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow(this.executorService);
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (this.processor != null) {
            if (this.afterConsumer) {
                exchange.getUnitOfWork().addSynchronization((Synchronization)new OnCompletionSynchronizationAfterConsumer(this.routeScoped, this.getRouteId()));
            } else {
                exchange.getUnitOfWork().addSynchronization((Synchronization)new OnCompletionSynchronizationBeforeConsumer(this.routeScoped, this.getRouteId()));
            }
        }
        callback.done(true);
        return true;
    }

    protected boolean isCreateCopy() {
        return this.executorService != null || this.afterConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void doProcess(Processor processor, Exchange exchange) {
        boolean stop = exchange.isRouteStop();
        exchange.setRouteStop(false);
        boolean failureHandled = exchange.getExchangeExtension().isFailureHandled();
        Boolean errorhandlerHandled = exchange.getExchangeExtension().getErrorHandlerHandled();
        exchange.getExchangeExtension().setErrorHandlerHandled(null);
        boolean rollbackOnly = exchange.isRollbackOnly();
        exchange.setRollbackOnly(false);
        boolean rollbackOnlyLast = exchange.isRollbackOnlyLast();
        exchange.setRollbackOnlyLast(false);
        boolean exhausted = exchange.getExchangeExtension().isRedeliveryExhausted();
        exchange.getExchangeExtension().setRedeliveryExhausted(false);
        Exception cause = exchange.getException();
        if (cause != null) {
            exchange.setException(null);
        }
        try {
            processor.process(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        finally {
            exchange.setRouteStop(stop);
            if (failureHandled) {
                exchange.getExchangeExtension().setFailureHandled(true);
            }
            if (errorhandlerHandled != null) {
                exchange.getExchangeExtension().setErrorHandlerHandled(errorhandlerHandled);
            }
            exchange.setRollbackOnly(rollbackOnly);
            exchange.setRollbackOnlyLast(rollbackOnlyLast);
            exchange.getExchangeExtension().setRedeliveryExhausted(exhausted);
            if (cause != null) {
                if (exchange.isFailed()) {
                    cause.addSuppressed(exchange.getException());
                }
                exchange.setException((Throwable)cause);
            }
        }
    }

    protected Exchange prepareExchange(Exchange exchange) {
        Exchange answer;
        if (this.isCreateCopy()) {
            answer = ExchangeHelper.createCorrelatedCopy((Exchange)exchange, (boolean)false);
            if (answer.hasOut()) {
                answer.setIn(answer.getOut());
                answer.setOut(null);
            }
            answer.setPattern(ExchangePattern.InOnly);
        } else {
            answer = exchange;
        }
        if (this.useOriginalBody) {
            LOG.trace("Using the original IN message instead of current");
            Message original = ExchangeHelper.getOriginalInMessage((Exchange)exchange);
            answer.setIn(original);
        }
        answer.setProperty(ExchangePropertyKey.ON_COMPLETION, (Object)Boolean.TRUE);
        return answer;
    }

    public String toString() {
        return this.id;
    }

    public String getTraceLabel() {
        return "onCompletion";
    }

    private final class OnCompletionSynchronizationAfterConsumer
    extends SynchronizationAdapter
    implements Ordered {
        private final boolean routeScoped;
        private final String routeId;

        public OnCompletionSynchronizationAfterConsumer(boolean routeScoped, String routeId) {
            this.routeScoped = routeScoped;
            this.routeId = routeId;
        }

        public int getOrder() {
            return 2147482647;
        }

        public SynchronizationRouteAware getRouteSynchronization() {
            return new SynchronizationRouteAware(){

                public void onBeforeRoute(Route route, Exchange exchange) {
                }

                public void onAfterRoute(Route route, Exchange exchange) {
                    if (OnCompletionSynchronizationAfterConsumer.this.routeScoped && route.getRouteId().equals(OnCompletionSynchronizationAfterConsumer.this.routeId)) {
                        ArrayList<String> routeIds = (ArrayList<String>)exchange.getProperty(ExchangePropertyKey.ON_COMPLETION_ROUTE_IDS, List.class);
                        if (routeIds == null) {
                            routeIds = new ArrayList<String>();
                            exchange.setProperty(ExchangePropertyKey.ON_COMPLETION_ROUTE_IDS, routeIds);
                        }
                        routeIds.add(route.getRouteId());
                    }
                }
            };
        }

        public void onComplete(Exchange exchange) {
            if (this.shouldSkip(exchange, OnCompletionProcessor.this.onFailureOnly)) {
                return;
            }
            final Exchange copy = OnCompletionProcessor.this.prepareExchange(exchange);
            if (OnCompletionProcessor.this.executorService != null) {
                OnCompletionProcessor.this.executorService.submit(new Callable<Exchange>(){

                    @Override
                    public Exchange call() throws Exception {
                        LOG.debug("Processing onComplete: {}", (Object)copy);
                        OnCompletionProcessor.doProcess(OnCompletionProcessor.this.processor, copy);
                        return copy;
                    }
                });
            } else {
                LOG.debug("Processing onComplete: {}", (Object)copy);
                OnCompletionProcessor.doProcess(OnCompletionProcessor.this.processor, copy);
            }
        }

        public void onFailure(Exchange exchange) {
            if (this.shouldSkip(exchange, OnCompletionProcessor.this.onCompleteOnly)) {
                return;
            }
            final Exchange copy = OnCompletionProcessor.this.prepareExchange(exchange);
            final Exception original = copy.getException();
            if (original != null) {
                copy.setException(null);
            }
            if (OnCompletionProcessor.this.executorService != null) {
                OnCompletionProcessor.this.executorService.submit(new Callable<Exchange>(){

                    @Override
                    public Exchange call() throws Exception {
                        LOG.debug("Processing onFailure: {}", (Object)copy);
                        OnCompletionProcessor.doProcess(OnCompletionProcessor.this.processor, copy);
                        copy.setException((Throwable)original);
                        return null;
                    }
                });
            } else {
                LOG.debug("Processing onFailure: {}", (Object)copy);
                OnCompletionProcessor.doProcess(OnCompletionProcessor.this.processor, copy);
                copy.setException((Throwable)original);
            }
        }

        private boolean shouldSkip(Exchange exchange, boolean onCompleteOrOnFailureOnly) {
            List routeIds;
            String currentRouteId = ExchangeHelper.getRouteId((Exchange)exchange);
            if (!this.routeScoped && currentRouteId != null && !this.routeId.equals(currentRouteId)) {
                return true;
            }
            if (this.routeScoped && ((routeIds = (List)exchange.getProperty(ExchangePropertyKey.ON_COMPLETION_ROUTE_IDS, List.class)) == null || !routeIds.contains(this.routeId))) {
                return true;
            }
            if (onCompleteOrOnFailureOnly) {
                return true;
            }
            return OnCompletionProcessor.this.onWhen != null && !OnCompletionProcessor.this.onWhen.matches(exchange);
        }

        public String toString() {
            if (!OnCompletionProcessor.this.onCompleteOnly && !OnCompletionProcessor.this.onFailureOnly) {
                return "onCompleteOrFailure";
            }
            if (OnCompletionProcessor.this.onCompleteOnly) {
                return "onCompleteOnly";
            }
            return "onFailureOnly";
        }

        public void beforeHandover(Exchange target) {
            LOG.debug("beforeHandover from Route {}", (Object)target.getFromRouteId());
            String exchangeRouteId = target.getFromRouteId();
            if (this.routeScoped && exchangeRouteId != null && exchangeRouteId.equals(this.routeId)) {
                ArrayList<String> routeIds = (ArrayList<String>)target.getProperty(ExchangePropertyKey.ON_COMPLETION_ROUTE_IDS, List.class);
                if (routeIds == null) {
                    routeIds = new ArrayList<String>();
                    target.setProperty(ExchangePropertyKey.ON_COMPLETION_ROUTE_IDS, routeIds);
                }
                if (!routeIds.contains(exchangeRouteId)) {
                    routeIds.add(exchangeRouteId);
                }
            }
        }
    }

    private final class OnCompletionSynchronizationBeforeConsumer
    extends SynchronizationAdapter
    implements Ordered {
        private final boolean routeScoped;
        private final String routeId;

        public OnCompletionSynchronizationBeforeConsumer(boolean routeScoped, String routeId) {
            this.routeScoped = routeScoped;
            this.routeId = routeId;
        }

        public int getOrder() {
            return 2147482647;
        }

        public SynchronizationRouteAware getRouteSynchronization() {
            return new SynchronizationRouteAware(){

                public void onBeforeRoute(Route route, Exchange exchange) {
                }

                public void onAfterRoute(Route route, Exchange exchange) {
                    LOG.debug("onAfterRoute from Route {}", (Object)route.getRouteId());
                    if (OnCompletionSynchronizationBeforeConsumer.this.routeScoped && !route.getRouteId().equals(OnCompletionSynchronizationBeforeConsumer.this.routeId)) {
                        return;
                    }
                    if (!(OnCompletionSynchronizationBeforeConsumer.this.routeScoped || route.getRouteId().equals(OnCompletionSynchronizationBeforeConsumer.this.routeId) && exchange.getFromRouteId().equals(OnCompletionSynchronizationBeforeConsumer.this.routeId))) {
                        return;
                    }
                    if (exchange.isFailed() && OnCompletionProcessor.this.onCompleteOnly) {
                        return;
                    }
                    if (!exchange.isFailed() && OnCompletionProcessor.this.onFailureOnly) {
                        return;
                    }
                    if (OnCompletionProcessor.this.onWhen != null && !OnCompletionProcessor.this.onWhen.matches(exchange)) {
                        return;
                    }
                    final Exchange copy = OnCompletionProcessor.this.prepareExchange(exchange);
                    if (OnCompletionProcessor.this.executorService != null) {
                        OnCompletionProcessor.this.executorService.submit(new Callable<Exchange>(){

                            @Override
                            public Exchange call() throws Exception {
                                LOG.debug("Processing onAfterRoute: {}", (Object)copy);
                                OnCompletionProcessor.doProcess(OnCompletionProcessor.this.processor, copy);
                                return copy;
                            }
                        });
                    } else {
                        LOG.debug("Processing onAfterRoute: {}", (Object)copy);
                        OnCompletionProcessor.doProcess(OnCompletionProcessor.this.processor, copy);
                    }
                }
            };
        }

        public boolean allowHandover() {
            return false;
        }

        public String toString() {
            return "onAfterRoute";
        }
    }
}

