/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.rsocket.service;

import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.lang.Nullable;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.messaging.rsocket.service.RSocketRequestValues;
import org.springframework.messaging.rsocket.service.RSocketServiceArgumentResolver;
import org.springframework.util.Assert;

public class PayloadArgumentResolver
implements RSocketServiceArgumentResolver {
    private final ReactiveAdapterRegistry reactiveAdapterRegistry;
    private final boolean useDefaultResolution;

    public PayloadArgumentResolver(ReactiveAdapterRegistry reactiveAdapterRegistry, boolean useDefaultResolution) {
        this.useDefaultResolution = useDefaultResolution;
        Assert.notNull((Object)reactiveAdapterRegistry, "ReactiveAdapterRegistry is required");
        this.reactiveAdapterRegistry = reactiveAdapterRegistry;
    }

    @Override
    public boolean resolve(@Nullable Object argument, MethodParameter parameter, RSocketRequestValues.Builder requestValues) {
        Payload annot = parameter.getParameterAnnotation(Payload.class);
        if (annot == null && !this.useDefaultResolution) {
            return false;
        }
        if (argument != null) {
            ReactiveAdapter reactiveAdapter = this.reactiveAdapterRegistry.getAdapter(parameter.getParameterType());
            if (reactiveAdapter == null) {
                requestValues.setPayloadValue(argument);
            } else {
                MethodParameter nestedParameter = parameter.nested();
                String message = "Async type for @Payload should produce value(s)";
                Assert.isTrue(nestedParameter.getNestedParameterType() != Void.class, message);
                Assert.isTrue(!reactiveAdapter.isNoValue(), message);
                requestValues.setPayload(reactiveAdapter.toPublisher(argument), ParameterizedTypeReference.forType(nestedParameter.getNestedGenericParameterType()));
            }
        }
        return true;
    }
}

