/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.RouteTemplateContext;
import org.apache.camel.model.app.BeanConstructorsAdapter;
import org.apache.camel.model.app.BeanPropertiesAdapter;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.ResourceAware;

@Metadata(label="configuration")
@XmlRootElement(name="beanFactory")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BeanFactoryDefinition<P>
implements ResourceAware {
    @XmlTransient
    private Resource resource;
    @XmlTransient
    private P parent;
    @XmlTransient
    private Class<?> beanClass;
    @XmlTransient
    private RouteTemplateContext.BeanSupplier<Object> beanSupplier;
    @XmlAttribute(required=true)
    private String name;
    @XmlAttribute(required=true)
    private String type;
    @XmlAttribute
    private String initMethod;
    @XmlAttribute
    private String destroyMethod;
    @XmlAttribute
    private String factoryMethod;
    @XmlAttribute
    private String factoryBean;
    @XmlAttribute
    private String builderClass;
    @XmlAttribute
    @Metadata(defaultValue="build")
    private String builderMethod;
    @XmlAttribute
    @Metadata(label="advanced")
    private String scriptLanguage;
    @XmlElement(name="constructors")
    @XmlJavaTypeAdapter(value=BeanConstructorsAdapter.class)
    private Map<Integer, Object> constructors;
    @XmlElement(name="properties")
    @XmlJavaTypeAdapter(value=BeanPropertiesAdapter.class)
    private Map<String, Object> properties;
    @XmlElement(name="script")
    @Metadata(label="advanced")
    private String script;

    public void setParent(P parent) {
        this.parent = parent;
    }

    public void setBeanType(Class<?> beanType) {
        this.beanClass = beanType;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public RouteTemplateContext.BeanSupplier<Object> getBeanSupplier() {
        return this.beanSupplier;
    }

    public void setBeanSupplier(RouteTemplateContext.BeanSupplier<Object> beanSupplier) {
        this.beanSupplier = beanSupplier;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getInitMethod() {
        return this.initMethod;
    }

    public void setInitMethod(String initMethod) {
        this.initMethod = initMethod;
    }

    public String getDestroyMethod() {
        return this.destroyMethod;
    }

    public void setDestroyMethod(String destroyMethod) {
        this.destroyMethod = destroyMethod;
    }

    public String getFactoryMethod() {
        return this.factoryMethod;
    }

    public void setFactoryMethod(String factoryMethod) {
        this.factoryMethod = factoryMethod;
    }

    public String getFactoryBean() {
        return this.factoryBean;
    }

    public void setFactoryBean(String factoryBean) {
        this.factoryBean = factoryBean;
    }

    public String getBuilderClass() {
        return this.builderClass;
    }

    public void setBuilderClass(String builderClass) {
        this.builderClass = builderClass;
    }

    public String getBuilderMethod() {
        return this.builderMethod;
    }

    public void setBuilderMethod(String builderMethod) {
        this.builderMethod = builderMethod;
    }

    public Map<Integer, Object> getConstructors() {
        return this.constructors;
    }

    public void setConstructors(Map<Integer, Object> constructors) {
        this.constructors = constructors;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public String getScriptLanguage() {
        return this.scriptLanguage;
    }

    public void setScriptLanguage(String scriptLanguage) {
        this.scriptLanguage = scriptLanguage;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getScript() {
        return this.script;
    }

    public BeanFactoryDefinition<P> type(String prefix, Class<?> type) {
        if (((String)prefix).startsWith("#type") || ((String)prefix).startsWith("#class")) {
            if (!((String)prefix).endsWith(":")) {
                prefix = (String)prefix + ":";
            }
            this.setType((String)prefix + type.getName());
        }
        this.setBeanType(type);
        return this;
    }

    public BeanFactoryDefinition<P> type(String type) {
        if (!((String)type).startsWith("#")) {
            type = "#class:" + (String)type;
        }
        this.setType((String)type);
        return this;
    }

    public BeanFactoryDefinition<P> typeClass(Class<?> type) {
        this.setType("#class:" + type.getName());
        return this;
    }

    public BeanFactoryDefinition<P> typeClass(String type) {
        this.setType("#class:" + type);
        return this;
    }

    public BeanFactoryDefinition<P> beanType(Class<?> type) {
        this.setBeanType(type);
        return this;
    }

    public P bean(Class<?> type) {
        return this.bean(type, null);
    }

    public P bean(Class<?> type, String method) {
        this.setScriptLanguage("bean");
        this.setBeanType(type);
        if (method != null) {
            this.setScript(type.getName() + "?method=" + method);
        } else {
            this.setScript(type.getName());
        }
        return this.parent;
    }

    public BeanFactoryDefinition<P> initMethod(String initMethod) {
        this.setInitMethod(initMethod);
        return this;
    }

    public BeanFactoryDefinition<P> destroyMethod(String destroyMethod) {
        this.setDestroyMethod(destroyMethod);
        return this;
    }

    public BeanFactoryDefinition<P> factoryMethod(String factoryMethod) {
        this.setFactoryMethod(factoryMethod);
        return this;
    }

    public BeanFactoryDefinition<P> factoryBean(String factoryBean) {
        this.setFactoryBean(factoryBean);
        return this;
    }

    public BeanFactoryDefinition<P> builderClass(String builderClass) {
        this.setBuilderClass(builderClass);
        return this;
    }

    public BeanFactoryDefinition<P> builderMethod(String builderMethod) {
        this.setBuilderMethod(builderMethod);
        return this;
    }

    public P groovy(String script) {
        this.setScriptLanguage("groovy");
        this.setScript(script);
        return this.parent;
    }

    public P joor(String script) {
        this.setScriptLanguage("joor");
        this.setScript(script);
        return this.parent;
    }

    public P java(String script) {
        return this.joor(script);
    }

    public P language(String language, String script) {
        this.setScriptLanguage(language);
        this.setScript(script);
        return this.parent;
    }

    public P mvel(String script) {
        this.setScriptLanguage("mvel");
        this.setScript(script);
        return this.parent;
    }

    public P ognl(String script) {
        this.setScriptLanguage("ognl");
        this.setScript(script);
        return this.parent;
    }

    public BeanFactoryDefinition<P> constructor(Integer index, String value) {
        if (this.constructors == null) {
            this.constructors = new LinkedHashMap<Integer, Object>();
        }
        this.constructors.put(index, value);
        return this;
    }

    public BeanFactoryDefinition<P> constructors(Map<Integer, Object> constructors) {
        this.constructors = constructors;
        return this;
    }

    public BeanFactoryDefinition<P> property(String key, String value) {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, Object>();
        }
        this.properties.put(key, value);
        return this;
    }

    public BeanFactoryDefinition<P> properties(Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }

    public P end() {
        return this.parent;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }
}

