/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.impl;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.qpid.proton.codec.Data;
import org.apache.qpid.proton.codec.impl.AtomicElement;
import org.apache.qpid.proton.codec.impl.Element;

class UUIDElement
extends AtomicElement<UUID> {
    private final UUID _value;

    UUIDElement(Element parent, Element prev, UUID u) {
        super(parent, prev);
        this._value = u;
    }

    @Override
    public int size() {
        return this.isElementOfArray() ? 16 : 17;
    }

    @Override
    public UUID getValue() {
        return this._value;
    }

    @Override
    public Data.DataType getDataType() {
        return Data.DataType.UUID;
    }

    @Override
    public int encode(ByteBuffer b) {
        int size = this.size();
        if (b.remaining() >= size) {
            if (size == 17) {
                b.put((byte)-104);
            }
            b.putLong(this._value.getMostSignificantBits());
            b.putLong(this._value.getLeastSignificantBits());
            return size;
        }
        return 0;
    }
}

