/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.language;

import java.net.URLDecoder;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.language.LanguageEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.spi.Language;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResourceHelper;
import org.apache.camel.util.StringHelper;

public class LanguageComponent
extends UriEndpointComponent {
    public static final String RESOURCE = "resource:";

    public LanguageComponent() {
        super(LanguageEndpoint.class);
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String name = StringHelper.before(remaining, ":");
        String script = StringHelper.after(remaining, ":");
        if (name == null && script == null) {
            name = remaining;
        }
        if (ObjectHelper.isEmpty(name)) {
            throw new IllegalArgumentException("Illegal syntax. Name of language not given in uri: " + uri);
        }
        Language language = this.getCamelContext().resolveLanguage(name);
        String resourceUri = null;
        String resource = script;
        if (resource != null) {
            if (resource.startsWith(RESOURCE)) {
                resource = resource.substring(RESOURCE.length());
            }
            if (ResourceHelper.hasScheme(resource)) {
                resourceUri = resource;
                script = null;
            } else {
                script = URLDecoder.decode(script, "UTF-8");
                resourceUri = null;
            }
        }
        LanguageEndpoint endpoint = new LanguageEndpoint(uri, this, language, null, resourceUri);
        endpoint.setScript(script);
        this.setProperties(endpoint, parameters);
        return endpoint;
    }
}

