/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.spring4.xml.encryption;

import org.jasypt.spring4.properties.EncryptablePropertyPlaceholderConfigurer;
import org.jasypt.spring4.properties.EncryptablePropertySourcesPlaceholderConfigurer;
import org.jasypt.spring4.xml.encryption.AbstractEncryptablePropertyLoadingBeanDefinitionParser;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

final class EncryptablePropertyPlaceholderBeanDefinitionParser
extends AbstractEncryptablePropertyLoadingBeanDefinitionParser {
    private static final String SYSTEM_PROPERTIES_MODE_ATTRIBUTE = "system-properties-mode";
    private static final String ENCRYPTOR_ATTRIBUTE = "encryptor";
    private static final String SYSTEM_PROPERTIES_MODE_DEFAULT = "ENVIRONMENT";

    EncryptablePropertyPlaceholderBeanDefinitionParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        if (element.getAttribute(SYSTEM_PROPERTIES_MODE_ATTRIBUTE).equals(SYSTEM_PROPERTIES_MODE_DEFAULT)) {
            return EncryptablePropertySourcesPlaceholderConfigurer.class;
        }
        return EncryptablePropertyPlaceholderConfigurer.class;
    }

    @Override
    protected void doParse(Element element, BeanDefinitionBuilder builder) {
        String encryptorBeanName;
        super.doParse(element, builder);
        builder.addPropertyValue("ignoreUnresolvablePlaceholders", (Object)Boolean.valueOf(element.getAttribute("ignore-unresolvable")));
        String systemPropertiesModeName = element.getAttribute(SYSTEM_PROPERTIES_MODE_ATTRIBUTE);
        if (StringUtils.hasLength((String)systemPropertiesModeName) && !systemPropertiesModeName.equals(SYSTEM_PROPERTIES_MODE_DEFAULT)) {
            builder.addPropertyValue("systemPropertiesModeName", (Object)("SYSTEM_PROPERTIES_MODE_" + systemPropertiesModeName));
        }
        if (StringUtils.hasText((String)(encryptorBeanName = element.getAttribute(ENCRYPTOR_ATTRIBUTE)))) {
            builder.addConstructorArgReference(encryptorBeanName);
        }
    }
}

