/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.lang;

import java.io.Serializable;
import java.util.EnumMap;
import java.util.EnumSet;
import org.linkedin.util.collections.CollectionsUtils;
import org.linkedin.util.lang.LangUtils;

public class MemorySize
implements Comparable<MemorySize>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final MemorySize ZERO_BYTES = new MemorySize(0L, SizeUnit.BYTE);
    public static final MemorySize ZERO_KILO_BYTES = new MemorySize(0L, SizeUnit.KILO_BYTE);
    public static final MemorySize ZERO_MEGA_BYTES = new MemorySize(0L, SizeUnit.MEGA_BYTE);
    public static final MemorySize ZERO_GIGA_BYTES = new MemorySize(0L, SizeUnit.GIGA_BYTE);
    public static final MemorySize ZERO_TERA_BYTES = new MemorySize(0L, SizeUnit.TERA_BYTE);
    private static final SizeUnit[] ORDERED_SIZE_UNIT = CollectionsUtils.reverse(SizeUnit.values());
    private static final EnumMap<SizeUnit, MemorySize> ZERO_SIZES = new EnumMap(SizeUnit.class);
    private final long _size;
    private final SizeUnit _sizeUnit;

    public MemorySize(long sizeInBytes) {
        this(sizeInBytes, SizeUnit.BYTE);
    }

    public MemorySize(long size, SizeUnit sizeUnit) {
        this._size = size;
        this._sizeUnit = sizeUnit;
    }

    public long getSize() {
        return this._size;
    }

    public SizeUnit getSizeUnit() {
        return this._sizeUnit;
    }

    public long getSizeInBytes() {
        return this.getSize() * this.getSizeUnit().getBytesCount();
    }

    public long getSizeInKiloBytes() {
        return this.getSizeInBytes() / SizeUnit.KILO_BYTE.getBytesCount();
    }

    public long getSizeInMegaBytes() {
        return this.getSizeInBytes() / SizeUnit.MEGA_BYTE.getBytesCount();
    }

    public long getSizeInGigaBytes() {
        return this.getSizeInBytes() / SizeUnit.GIGA_BYTE.getBytesCount();
    }

    public long getSizeInTeraBytes() {
        return this.getSizeInBytes() / SizeUnit.TERA_BYTE.getBytesCount();
    }

    public double getFractionalSize(SizeUnit sizeUnit) {
        return (double)this.getSizeInBytes() / (double)sizeUnit.getBytesCount();
    }

    public String getFractionalSizeAsString() {
        if (this._size == 0L) {
            return "0";
        }
        long sizeInBytes = this.getSizeInBytes();
        for (SizeUnit sizeUnit : ORDERED_SIZE_UNIT) {
            if (sizeUnit == SizeUnit.BYTE) {
                return String.valueOf(sizeInBytes);
            }
            if (sizeInBytes < sizeUnit.getBytesCount()) continue;
            double fractionalSize = (double)sizeInBytes / (double)sizeUnit.getBytesCount();
            return String.format("%.2f%s", fractionalSize, sizeUnit.getDisplayChar());
        }
        throw new RuntimeException("should not reach this line...");
    }

    public MemorySize truncate(SizeUnit sizeUnit) {
        if (this.getSizeUnit() == sizeUnit) {
            return this;
        }
        long sizeInBytes = this.getSizeInBytes();
        if (sizeInBytes >= sizeUnit.getBytesCount()) {
            return new MemorySize(sizeInBytes / sizeUnit.getBytesCount(), sizeUnit);
        }
        return ZERO_SIZES.get((Object)sizeUnit);
    }

    public MemorySize add(MemorySize other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (this.getSizeUnit() == other.getSizeUnit()) {
            return new MemorySize(this.getSize() + other.getSize(), this.getSizeUnit());
        }
        return new MemorySize(this.getSizeInBytes() + other.getSizeInBytes(), SizeUnit.BYTE);
    }

    public MemorySize subtract(MemorySize other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (this.getSizeUnit() == other.getSizeUnit()) {
            return new MemorySize(this.getSize() - other.getSize(), this.getSizeUnit());
        }
        return new MemorySize(this.getSizeInBytes() - other.getSizeInBytes(), SizeUnit.BYTE);
    }

    public String getAsString(SizeUnit ... sizeUnits) {
        if (sizeUnits == null || sizeUnits.length == 0) {
            return this.toString();
        }
        return this.getAsString(CollectionsUtils.toEnumSet(SizeUnit.class, (Enum[])sizeUnits));
    }

    public String getAsString(EnumSet<SizeUnit> sizeUnits) {
        if (sizeUnits == null || sizeUnits.size() == 0) {
            return this.toString();
        }
        StringBuilder sb = new StringBuilder();
        MemorySize ms = this;
        Object[] unitsAsArr = sizeUnits.toArray();
        int len = unitsAsArr.length;
        for (int i = len - 1; i > -1; --i) {
            MemorySize prevMs = ms;
            if ((ms = ms.truncate((SizeUnit)((Object)unitsAsArr[i]))).getSize() > 0L) {
                sb.append(ms.getSize()).append(ms.getSizeUnit().getDisplayChar());
            }
            ms = prevMs.subtract(ms);
        }
        if (sb.length() == 0) {
            SizeUnit smallestUnit = (SizeUnit)((Object)unitsAsArr[0]);
            sb.append("0").append(smallestUnit.getDisplayChar());
        }
        return sb.toString();
    }

    public String getCanonicalString() {
        return this.getAsString(ORDERED_SIZE_UNIT);
    }

    public String toString() {
        return this.getFractionalSizeAsString();
    }

    @Override
    public int compareTo(MemorySize memorySize) {
        if (memorySize == null) {
            throw new NullPointerException();
        }
        if (this.getSizeUnit() == memorySize.getSizeUnit()) {
            return LangUtils.compare(this.getSize(), memorySize.getSize());
        }
        return LangUtils.compare(this.getSizeInBytes(), memorySize.getSizeInBytes());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.compareTo((MemorySize)o) == 0;
    }

    public int hashCode() {
        long size = this.getSizeInBytes();
        return (int)(size ^ size >>> 32);
    }

    public static MemorySize create(MemorySize ... memorySizes) {
        if (memorySizes == null) {
            return null;
        }
        if (memorySizes.length == 0) {
            return ZERO_BYTES;
        }
        MemorySize res = memorySizes[0];
        for (int i = 1; i < memorySizes.length; ++i) {
            MemorySize memorySize = memorySizes[i];
            if (memorySize == null) continue;
            res = res.add(memorySize);
        }
        return res;
    }

    public static MemorySize parse(String memorySizeAsStr) {
        return MemorySize.parseMemorySize(memorySizeAsStr);
    }

    public static MemorySize parseMemorySize(String memorySizeAsStr) {
        if (memorySizeAsStr == null || memorySizeAsStr.length() == 0) {
            return null;
        }
        int len = memorySizeAsStr.length();
        int orderedSizeUnitIdx = 0;
        int orderedSizeUnitLen = ORDERED_SIZE_UNIT.length;
        int startDigitsIdx = 0;
        boolean expectingDigits = true;
        MemorySize ms = ZERO_BYTES;
        for (int i = 0; i < len; ++i) {
            char c = memorySizeAsStr.charAt(i);
            if (c >= '0' && c <= '9') {
                expectingDigits = false;
                continue;
            }
            if (expectingDigits) {
                throw new IllegalArgumentException("Unable to parse '" + memorySizeAsStr + "': found '" + c + "' at pos " + i + ", was expecting a digit");
            }
            while (orderedSizeUnitIdx < orderedSizeUnitLen) {
                SizeUnit sizeUnit = ORDERED_SIZE_UNIT[orderedSizeUnitIdx];
                String displayChar = sizeUnit.getDisplayChar();
                if (displayChar.length() > 0 && c == displayChar.charAt(0)) {
                    try {
                        long size = Long.parseLong(memorySizeAsStr.substring(startDigitsIdx, i));
                        ms = ms.add(new MemorySize(size, sizeUnit));
                        ++orderedSizeUnitIdx;
                        startDigitsIdx = i + 1;
                        expectingDigits = true;
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Unable to parse '" + memorySizeAsStr + "'", e);
                    }
                }
                ++orderedSizeUnitIdx;
            }
            if (orderedSizeUnitIdx != orderedSizeUnitLen) continue;
            throw new IllegalArgumentException("Unable to parse '" + memorySizeAsStr + "': found invalid character '" + c + "' at pos " + i);
        }
        if (startDigitsIdx < len) {
            try {
                long size = Long.parseLong(memorySizeAsStr.substring(startDigitsIdx, len));
                ms = ms.add(new MemorySize(size, SizeUnit.BYTE));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Unable to parse '" + memorySizeAsStr + "'", e);
            }
        }
        return ms;
    }

    static {
        ZERO_SIZES.put(SizeUnit.BYTE, ZERO_BYTES);
        ZERO_SIZES.put(SizeUnit.KILO_BYTE, ZERO_KILO_BYTES);
        ZERO_SIZES.put(SizeUnit.MEGA_BYTE, ZERO_MEGA_BYTES);
        ZERO_SIZES.put(SizeUnit.GIGA_BYTE, ZERO_GIGA_BYTES);
        ZERO_SIZES.put(SizeUnit.TERA_BYTE, ZERO_TERA_BYTES);
    }

    public static enum SizeUnit {
        BYTE(1L, ""),
        KILO_BYTE(1024L * BYTE.getBytesCount(), "k"),
        MEGA_BYTE(1024L * KILO_BYTE.getBytesCount(), "m"),
        GIGA_BYTE(1024L * MEGA_BYTE.getBytesCount(), "g"),
        TERA_BYTE(1024L * GIGA_BYTE.getBytesCount(), "t");

        private final long _bytesCount;
        private final String _displayChar;

        private SizeUnit(long bytesCount, String displayChar) {
            this._bytesCount = bytesCount;
            this._displayChar = displayChar;
        }

        public long getBytesCount() {
            return this._bytesCount;
        }

        public String getDisplayChar() {
            return this._displayChar;
        }
    }
}

