/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.format.number;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.springframework.format.number.AbstractNumberFormatter;

public class NumberStyleFormatter
extends AbstractNumberFormatter {
    private String pattern;

    public NumberStyleFormatter() {
    }

    public NumberStyleFormatter(String pattern) {
        this.pattern = pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public NumberFormat getNumberFormat(Locale locale) {
        NumberFormat format2 = NumberFormat.getInstance(locale);
        if (!(format2 instanceof DecimalFormat)) {
            if (this.pattern != null) {
                throw new IllegalStateException("Cannot support pattern for non-DecimalFormat: " + format2);
            }
            return format2;
        }
        DecimalFormat decimalFormat = (DecimalFormat)format2;
        decimalFormat.setParseBigDecimal(true);
        if (this.pattern != null) {
            decimalFormat.applyPattern(this.pattern);
        }
        return decimalFormat;
    }
}

