/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.https;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.broker.SslContext;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportServer;
import org.apache.activemq.transport.http.HttpTransportFactory;
import org.apache.activemq.transport.https.HttpsClientTransport;
import org.apache.activemq.transport.https.HttpsTransportServer;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.URISupport;
import org.apache.activemq.wireformat.WireFormat;

public class HttpsTransportFactory
extends HttpTransportFactory {
    public TransportServer doBind(String brokerId, URI location) throws IOException {
        return this.doBind(location);
    }

    @Override
    public TransportServer doBind(URI location) throws IOException {
        try {
            HashMap<String, String> options = new HashMap<String, String>(URISupport.parseParameters(location));
            HttpsTransportServer result = new HttpsTransportServer(location, this, SslContext.getCurrentSslContext());
            Map<String, Object> httpOptions = IntrospectionSupport.extractProperties(options, "http.");
            Map<String, Object> transportOptions = IntrospectionSupport.extractProperties(options, "transport.");
            result.setTransportOption(transportOptions);
            result.setHttpOptions(httpOptions);
            return result;
        }
        catch (URISyntaxException e) {
            throw IOExceptionSupport.create(e);
        }
    }

    @Override
    protected Transport createTransport(URI location, WireFormat wf) throws IOException {
        try {
            URI uri = URISupport.removeQuery(location);
            HashMap<String, String> options = new HashMap<String, String>(URISupport.parseParameters(location));
            Map<String, Object> transportOptions = IntrospectionSupport.extractProperties(options, "transport.");
            boolean verifyHostName = true;
            if (transportOptions.containsKey("verifyHostName")) {
                verifyHostName = Boolean.parseBoolean(transportOptions.get("verifyHostName").toString());
            }
            HttpsClientTransport clientTransport = new HttpsClientTransport(this.asTextWireFormat(wf), uri);
            clientTransport.setVerifyHostName(verifyHostName);
            return clientTransport;
        }
        catch (URISyntaxException e) {
            MalformedURLException cause = new MalformedURLException("Error removing query on " + location);
            cause.initCause(e);
            throw cause;
        }
    }

    @Override
    public Transport compositeConfigure(Transport transport, WireFormat format2, Map options) {
        options.remove("transport.verifyHostName");
        return super.compositeConfigure(transport, format2, options);
    }
}

