/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Map;
import org.apache.activemq.web.MessageServletSupport;
import org.apache.activemq.web.WebClient;

public class PortfolioPublishServlet
extends MessageServletSupport {
    private static final int MAX_DELTA_PERCENT = 1;
    private static final Map<String, Double> LAST_PRICES = new Hashtable<String, Double>();

    public void init() throws ServletException {
        super.init();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out = response.getWriter();
        String[] stocks = request.getParameterValues("stocks");
        if (stocks == null || stocks.length == 0) {
            out.println("<html><body>No <b>stocks</b> query parameter specified. Cannot publish market data</body></html>");
        } else {
            Integer total = (Integer)request.getSession(true).getAttribute("total");
            if (total == null) {
                total = 0;
            }
            int count = this.getNumberOfMessages(request);
            total = total + count;
            request.getSession().setAttribute("total", (Object)total);
            try {
                WebClient client = WebClient.getWebClient(request);
                for (int i = 0; i < count; ++i) {
                    this.sendMessage(client, stocks);
                }
                out.print("<html><head><meta http-equiv='refresh' content='");
                String refreshRate = request.getParameter("refresh");
                if (refreshRate == null || refreshRate.length() == 0) {
                    refreshRate = "1";
                }
                out.print(this.escape(refreshRate));
                out.println("'/></head>");
                out.println("<body>Published <b>" + this.escape(Integer.toString(count)) + "</b> of " + this.escape(Integer.toString(total)) + " price messages.  Refresh = " + this.escape(refreshRate) + "s");
                out.println("</body></html>");
            }
            catch (JMSException e) {
                out.println("<html><body>Failed sending price messages due to <b>" + String.valueOf((Object)e) + "</b></body></html>");
                this.log("Failed to send message: " + String.valueOf((Object)e), e);
            }
        }
    }

    protected void sendMessage(WebClient client, String[] stocks) throws JMSException {
        Session session = client.getSession();
        int idx = 0;
        while ((idx = (int)Math.round((double)stocks.length * Math.random())) >= stocks.length) {
        }
        String stock = stocks[idx];
        Topic destination = session.createTopic("STOCKS." + stock);
        String stockText = this.createStockText(stock);
        this.log("Sending: " + stockText + " on destination: " + String.valueOf(destination));
        TextMessage message = session.createTextMessage(stockText);
        client.send((Destination)destination, (Message)message);
    }

    protected String createStockText(String stock) {
        Double value = LAST_PRICES.get(stock);
        if (value == null) {
            value = Math.random() * 100.0;
        }
        double oldPrice = value;
        value = this.mutatePrice(oldPrice);
        LAST_PRICES.put(stock, value);
        double price = value;
        double offer = price * 1.001;
        String movement = price > oldPrice ? "up" : "down";
        return "<price stock='" + stock + "' bid='" + price + "' offer='" + offer + "' movement='" + movement + "'/>";
    }

    protected double mutatePrice(double price) {
        double percentChange = 2.0 * Math.random() * 1.0 - 1.0;
        return price * (100.0 + percentChange) / 100.0;
    }

    protected int getNumberOfMessages(HttpServletRequest request) {
        String name = request.getParameter("count");
        if (name != null) {
            return Integer.parseInt(name);
        }
        return 1;
    }

    protected String escape(String text) throws IOException {
        return URLEncoder.encode(text, "UTF-8");
    }
}

