/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web.filter;

import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.activemq.web.filter.ApplicationContextFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ApplicationContextFilter
implements Filter {
    private static final transient Logger LOG = LoggerFactory.getLogger(ApplicationContextFilter.class);
    private ServletContext servletContext;
    private String applicationContextName = "applicationContext";
    private String requestContextName = "requestContext";
    private String requestName = "request";

    public void init(FilterConfig config) throws ServletException {
        this.servletContext = config.getServletContext();
        this.applicationContextName = this.getInitParameter(config, "applicationContextName", this.applicationContextName);
        this.requestContextName = this.getInitParameter(config, "requestContextName", this.requestContextName);
        this.requestName = this.getInitParameter(config, "requestName", this.requestName);
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.servletContext);
        Map wrapper = this.createApplicationContextWrapper(context);
        this.servletContext.setAttribute(this.applicationContextName, (Object)wrapper);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Map requestContextWrapper = this.createRequestContextWrapper(request);
        String path = ((HttpServletRequest)request).getRequestURI();
        request.setAttribute(this.requestContextName, (Object)requestContextWrapper);
        request.setAttribute(this.requestName, (Object)request);
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getApplicationContextName() {
        return this.applicationContextName;
    }

    public void setApplicationContextName(String variableName) {
        this.applicationContextName = variableName;
    }

    public String getRequestContextName() {
        return this.requestContextName;
    }

    public void setRequestContextName(String requestContextName) {
        this.requestContextName = requestContextName;
    }

    protected String getInitParameter(FilterConfig config, String key, String defaultValue) {
        String parameter = config.getInitParameter(key);
        return parameter != null ? parameter : defaultValue;
    }

    protected Map createApplicationContextWrapper(WebApplicationContext context) {
        1 wrapper = new /* Unavailable Anonymous Inner Class!! */;
        return wrapper;
    }

    protected Map createRequestContextWrapper(ServletRequest request) {
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.servletContext);
        2 wrapper = new /* Unavailable Anonymous Inner Class!! */;
        return wrapper;
    }

    protected Object bindRequestBean(Object bean, ServletRequest request) {
        ServletRequestDataBinder binder = new ServletRequestDataBinder(bean, null);
        binder.bind(request);
        return bean;
    }
}

