/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.SimplePojo;

public class ReflectionSupportTest
extends TestCase {
    List<ActiveMQDestination> favorites = new ArrayList<ActiveMQDestination>();
    String favoritesString = "[queue://test, topic://test]";
    List<ActiveMQDestination> nonFavorites = new ArrayList<ActiveMQDestination>();
    String nonFavoritesString = "[topic://test1]";

    public void setUp() {
        this.favorites.add((ActiveMQDestination)new ActiveMQQueue("test"));
        this.favorites.add((ActiveMQDestination)new ActiveMQTopic("test"));
        this.nonFavorites.add((ActiveMQDestination)new ActiveMQTopic("test1"));
    }

    public void testSetProperties() throws URISyntaxException {
        SimplePojo pojo = new SimplePojo();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("age", "27");
        map.put("name", "Hiram");
        map.put("enabled", "true");
        map.put("uri", "test://value");
        map.put("favorites", this.favoritesString);
        map.put("nonFavorites", this.nonFavoritesString);
        map.put("others", null);
        map.put("systems", "windows,mac");
        IntrospectionSupport.setProperties((Object)pojo, map);
        ReflectionSupportTest.assertEquals((int)27, (int)pojo.getAge());
        ReflectionSupportTest.assertEquals((String)"Hiram", (String)pojo.getName());
        ReflectionSupportTest.assertEquals((boolean)true, (boolean)pojo.isEnabled());
        ReflectionSupportTest.assertEquals((Object)new URI("test://value"), (Object)pojo.getUri());
        ReflectionSupportTest.assertEquals(this.favorites, pojo.getFavorites());
        ReflectionSupportTest.assertEquals(this.nonFavorites, pojo.getNonFavorites());
        ReflectionSupportTest.assertNull(pojo.getOthers());
        ReflectionSupportTest.assertEquals((String)"windows", (String)pojo.getSystems()[0]);
        ReflectionSupportTest.assertEquals((String)"mac", (String)pojo.getSystems()[1]);
    }

    public void testGetProperties() {
        SimplePojo pojo = new SimplePojo();
        pojo.setAge(31);
        pojo.setName("Dejan");
        pojo.setEnabled(true);
        pojo.setFavorites(this.favorites);
        pojo.setNonFavorites(this.nonFavorites);
        pojo.setOthers(null);
        pojo.setSystems(new String[]{"windows", "mac"});
        Properties props = new Properties();
        IntrospectionSupport.getProperties((Object)pojo, (Map)props, null);
        ReflectionSupportTest.assertEquals((Object)"Dejan", (Object)props.get("name"));
        ReflectionSupportTest.assertEquals((Object)"31", (Object)props.get("age"));
        ReflectionSupportTest.assertEquals((Object)"true", (Object)props.get("enabled"));
        ReflectionSupportTest.assertEquals((Object)this.favoritesString, (Object)props.get("favorites"));
        ReflectionSupportTest.assertEquals((Object)this.nonFavoritesString, (Object)props.get("nonFavorites"));
        ReflectionSupportTest.assertNull((Object)props.get("others"));
        ReflectionSupportTest.assertEquals((Object)"windows,mac", (Object)props.get("systems"));
    }

    public void testSetBoolean() {
        TestWitBoolean target = new TestWitBoolean();
        ReflectionSupportTest.assertTrue((target.getKeepAlive() == false ? 1 : 0) != 0);
        IntrospectionSupport.setProperty((Object)target, (String)"keepAlive", (Object)"TRUE");
        ReflectionSupportTest.assertTrue((boolean)target.getKeepAlive());
        IntrospectionSupport.setProperty((Object)target, (String)"keepAlive", (Object)"false");
        ReflectionSupportTest.assertTrue((target.getKeepAlive() == false ? 1 : 0) != 0);
    }

    public static class TestWitBoolean {
        private Boolean keepAlive = Boolean.FALSE;

        public Boolean getKeepAlive() {
            return this.keepAlive;
        }

        public void setKeepAlive(Boolean keepAlive) {
            this.keepAlive = keepAlive;
        }
    }
}

