/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import jakarta.jms.Destination;
import jakarta.jms.MessageConsumer;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.util.MessageIdList;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class TopicReplicationTest
extends JmsMultipleBrokersTestSupport {
    public static final int MSG_COUNT = 10;

    public void testReplication() throws Exception {
        this.createBroker((Resource)new ClassPathResource("org/apache/activemq/usecases/replication-broker1.xml"));
        this.createBroker((Resource)new ClassPathResource("org/apache/activemq/usecases/replication-broker2.xml"));
        this.createBroker((Resource)new ClassPathResource("org/apache/activemq/usecases/replication-broker3.xml"));
        this.createBroker((Resource)new ClassPathResource("org/apache/activemq/usecases/replication-broker4.xml"));
        ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"replication-broker1")).broker.waitUntilStarted();
        ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"replication-broker2")).broker.waitUntilStarted();
        ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"replication-broker3")).broker.waitUntilStarted();
        ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"replication-broker4")).broker.waitUntilStarted();
        ActiveMQDestination dest = this.createDestination("replication", true);
        MessageConsumer clientA = this.createConsumer("replication-broker2", (Destination)dest);
        MessageConsumer clientB = this.createConsumer("replication-broker3", (Destination)dest);
        MessageConsumer clientC = this.createConsumer("replication-broker4", (Destination)dest);
        MessageConsumer clientD = this.createConsumer("replication-broker4", (Destination)dest);
        Thread.sleep(2000L);
        MessageIdList msgsA = this.getConsumerMessages("replication-broker2", clientA);
        MessageIdList msgsB = this.getConsumerMessages("replication-broker3", clientB);
        MessageIdList msgsC = this.getConsumerMessages("replication-broker4", clientC);
        MessageIdList msgsD = this.getConsumerMessages("replication-broker4", clientD);
        this.sendMessages("replication-broker1", (Destination)dest, 10);
        msgsA.waitForMessagesToArrive(10);
        msgsB.waitForMessagesToArrive(10);
        msgsC.waitForMessagesToArrive(10);
        msgsD.waitForMessagesToArrive(10);
        TopicReplicationTest.assertEquals((int)10, (int)msgsA.getMessageCount());
        TopicReplicationTest.assertEquals((int)10, (int)msgsB.getMessageCount());
        TopicReplicationTest.assertEquals((int)10, (int)msgsC.getMessageCount());
        TopicReplicationTest.assertEquals((int)10, (int)msgsD.getMessageCount());
        this.sendMessages("replication-broker4", (Destination)dest, 10);
        msgsA.waitForMessagesToArrive(20);
        msgsB.waitForMessagesToArrive(20);
        msgsC.waitForMessagesToArrive(20);
        msgsD.waitForMessagesToArrive(20);
        TopicReplicationTest.assertEquals((int)20, (int)msgsA.getMessageCount());
        TopicReplicationTest.assertEquals((int)20, (int)msgsB.getMessageCount());
        TopicReplicationTest.assertEquals((int)20, (int)msgsC.getMessageCount());
        TopicReplicationTest.assertEquals((int)20, (int)msgsD.getMessageCount());
        this.sendMessages("replication-broker3", (Destination)dest, 10);
        msgsA.waitForMessagesToArrive(30);
        msgsB.waitForMessagesToArrive(30);
        msgsC.waitForMessagesToArrive(30);
        msgsD.waitForMessagesToArrive(30);
        TopicReplicationTest.assertEquals((int)30, (int)msgsA.getMessageCount());
        TopicReplicationTest.assertEquals((int)30, (int)msgsB.getMessageCount());
        TopicReplicationTest.assertEquals((int)30, (int)msgsC.getMessageCount());
        TopicReplicationTest.assertEquals((int)30, (int)msgsD.getMessageCount());
        this.sendMessages("replication-broker2", (Destination)dest, 10);
        msgsA.waitForMessagesToArrive(40);
        msgsB.waitForMessagesToArrive(40);
        msgsC.waitForMessagesToArrive(40);
        msgsD.waitForMessagesToArrive(40);
        TopicReplicationTest.assertEquals((int)40, (int)msgsA.getMessageCount());
        TopicReplicationTest.assertEquals((int)40, (int)msgsB.getMessageCount());
        TopicReplicationTest.assertEquals((int)40, (int)msgsC.getMessageCount());
        TopicReplicationTest.assertEquals((int)40, (int)msgsD.getMessageCount());
    }
}

