/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.Session;
import java.io.IOException;
import java.net.URI;
import java.util.Enumeration;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQQueue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueBrowsingLimitTest {
    private static final Logger LOG = LoggerFactory.getLogger(QueueBrowsingLimitTest.class);
    private BrokerService broker;
    private URI connectUri;
    private ActiveMQConnectionFactory factory;
    private final int browserLimit = 300;

    @Before
    public void startBroker() throws Exception {
        this.broker = this.createBroker();
        TransportConnector connector = this.broker.addConnector("tcp://0.0.0.0:0");
        this.broker.deleteAllMessages();
        this.broker.start();
        this.broker.waitUntilStarted();
        PolicyEntry policy = new PolicyEntry();
        policy.setMaxBrowsePageSize(300);
        this.broker.setDestinationPolicy(new PolicyMap());
        this.broker.getDestinationPolicy().setDefaultEntry(policy);
        this.connectUri = connector.getConnectUri();
        this.factory = new ActiveMQConnectionFactory(this.connectUri);
    }

    public BrokerService createBroker() throws IOException {
        return new BrokerService();
    }

    @After
    public void stopBroker() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
    }

    @Test
    public void testBrowsingLimited() throws Exception {
        int i;
        int messageToSend = 470;
        ActiveMQQueue queue = new ActiveMQQueue("TEST");
        Connection connection = this.factory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)queue);
        Object data = "";
        for (i = 0; i < 2048; ++i) {
            data = (String)data + "x";
        }
        for (i = 0; i < messageToSend; ++i) {
            producer.send((Message)session.createTextMessage((String)data));
        }
        QueueBrowser browser = session.createBrowser((Queue)queue);
        Enumeration enumeration = browser.getEnumeration();
        int received = 0;
        while (enumeration.hasMoreElements()) {
            Message m = (Message)enumeration.nextElement();
            LOG.info("Browsed message " + ++received + ": " + m.getJMSMessageID());
        }
        browser.close();
        Assert.assertEquals((long)300L, (long)received);
    }
}

