/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import org.apache.activemq.test.JmsTopicSendReceiveWithTwoConnectionsTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishOnTopicConsumedMessageTest
extends JmsTopicSendReceiveWithTwoConnectionsTest {
    private static final Logger LOG = LoggerFactory.getLogger(PublishOnTopicConsumedMessageTest.class);
    private MessageProducer replyProducer;

    @Override
    public synchronized void onMessage(Message message) {
        try {
            Message msgCopy = (Message)((org.apache.activemq.command.Message)message).copy();
            this.replyProducer.send(msgCopy);
            super.onMessage(message);
        }
        catch (JMSException e) {
            LOG.info("Failed to send message: " + e);
            e.printStackTrace();
        }
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object replyDestination = null;
        replyDestination = this.topic ? this.receiveSession.createTopic("REPLY." + this.getSubject()) : this.receiveSession.createQueue("REPLY." + this.getSubject());
        this.replyProducer = this.receiveSession.createProducer((Destination)replyDestination);
        LOG.info("Created replyProducer: " + this.replyProducer);
    }
}

