/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.net.URI;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.network.DiscoveryNetworkConnector;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.util.SocketProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkAsyncStartTest
extends JmsMultipleBrokersTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkAsyncStartTest.class);
    private String brokerBDomain = "localhost:61617";
    private String brokerCDomain = "localhost:61618";
    int bridgeCount = 0;
    public static final String KEYSTORE_TYPE = "jks";
    public static final String PASSWORD = "password";
    public static final String SERVER_KEYSTORE = "src/test/resources/server.keystore";
    public static final String TRUST_KEYSTORE = "src/test/resources/client.keystore";

    public void testAsyncNetworkStartupTcp() throws Exception {
        this.testAsyncNetworkStartup("tcp");
    }

    public void testAsyncNetworkStartupWithSlowConnectionCreationTcp() throws Exception {
        this.testAsyncNetworkStartupWithSlowConnectionCreation("tcp");
    }

    public void testAsyncNetworkStartupNio() throws Exception {
        this.testAsyncNetworkStartup("nio");
    }

    public void testAsyncNetworkStartupWithSlowConnectionCreationNio() throws Exception {
        this.testAsyncNetworkStartupWithSlowConnectionCreation("nio");
    }

    public void testAsyncNetworkStartupAuto() throws Exception {
        this.testAsyncNetworkStartup("auto");
    }

    public void testAsyncNetworkStartupWithSlowConnectionCreationAuto() throws Exception {
        this.testAsyncNetworkStartupWithSlowConnectionCreation("auto");
    }

    public void testAsyncNetworkStartupAutoNio() throws Exception {
        this.testAsyncNetworkStartup("auto+nio");
    }

    public void testAsyncNetworkStartupWithSlowConnectionCreationAutoNio() throws Exception {
        this.testAsyncNetworkStartupWithSlowConnectionCreation("auto+nio");
    }

    public void testAsyncNetworkStartupSsl() throws Exception {
        this.testAsyncNetworkStartup("ssl");
    }

    public void testAsyncNetworkStartupWithSlowConnectionCreationSsl() throws Exception {
        this.testAsyncNetworkStartupWithSlowConnectionCreation("ssl");
    }

    public void testAsyncNetworkStartupAutoSsl() throws Exception {
        this.testAsyncNetworkStartup("auto+ssl");
    }

    public void testAsyncNetworkStartupWithSlowConnectionCreationAutoSsl() throws Exception {
        this.testAsyncNetworkStartupWithSlowConnectionCreation("auto+ssl");
    }

    public void testAsyncNetworkStartupNioSsl() throws Exception {
        this.testAsyncNetworkStartup("nio+ssl");
    }

    public void testAsyncNetworkStartupWithSlowConnectionCreationNioSsl() throws Exception {
        this.testAsyncNetworkStartupWithSlowConnectionCreation("nio+ssl");
    }

    public void testAsyncNetworkStartupAutoNioSsl() throws Exception {
        this.testAsyncNetworkStartup("auto+nio+ssl");
    }

    public void testAsyncNetworkStartupWithSlowConnectionCreationAutoNioSsl() throws Exception {
        this.testAsyncNetworkStartupWithSlowConnectionCreation("auto+nio+ssl");
    }

    protected void testAsyncNetworkStartup(String transport) throws Exception {
        String brokerBUri = transport + "://" + this.brokerBDomain;
        String brokerCUri = transport + "://" + this.brokerCDomain;
        BrokerService brokerA = ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"BrokerA")).broker;
        this.bridgeBroker(brokerA, brokerBUri);
        this.bridgeBroker(brokerA, brokerCUri);
        LOG.info("starting A, no blocking on failed network connectors");
        brokerA.start();
        LOG.info("starting C transport connector");
        BrokerService brokerC = ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"BrokerC")).broker;
        brokerC.addConnector(brokerCUri);
        brokerC.start();
        NetworkAsyncStartTest.assertTrue((String)"got bridge to C", (boolean)this.waitForBridgeFormation(brokerA, 1, 1));
        LOG.info("Got bridge A->C");
        LOG.info("starting B transport connector");
        BrokerService brokerB = ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"BrokerB")).broker;
        brokerB.addConnector(brokerBUri);
        brokerB.start();
        NetworkAsyncStartTest.assertTrue((String)"got bridge to B", (boolean)this.waitForBridgeFormation(brokerA, 1, 0));
        NetworkAsyncStartTest.assertTrue((String)"got bridge to B&C", (boolean)this.waitForBridgeFormation(brokerA, 1, 1));
    }

    protected void testAsyncNetworkStartupWithSlowConnectionCreation(String transport) throws Exception {
        String brokerBUri = transport + "://" + this.brokerBDomain;
        String brokerCUri = transport + "://" + this.brokerCDomain;
        final BrokerService brokerA = ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"BrokerA")).broker;
        SocketProxy proxyToB = new SocketProxy();
        proxyToB.setPauseAtStart(true);
        proxyToB.setAcceptBacklog(1);
        proxyToB.setTarget(new URI(brokerBUri));
        proxyToB.open();
        this.bridgeBroker(brokerA, proxyToB.getUrl().toString());
        this.bridgeBroker(brokerA, proxyToB.getUrl().toString());
        this.bridgeBroker(brokerA, proxyToB.getUrl().toString());
        this.bridgeBroker(brokerA, proxyToB.getUrl().toString());
        this.bridgeBroker(brokerA, proxyToB.getUrl().toString());
        this.bridgeBroker(brokerA, proxyToB.getUrl().toString());
        this.bridgeBroker(brokerA, proxyToB.getUrl().toString());
        this.bridgeBroker(brokerA, brokerCUri);
        ExecutorService e = Executors.newCachedThreadPool();
        e.execute(new Runnable(){

            @Override
            public void run() {
                LOG.info("starting A");
                try {
                    brokerA.setNetworkConnectorStartAsync(true);
                    brokerA.start();
                }
                catch (Exception e) {
                    LOG.error("start failed", (Throwable)e);
                }
            }
        });
        LOG.info("starting transport connector on C");
        BrokerService brokerC = ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"BrokerC")).broker;
        brokerC.addConnector(brokerCUri);
        brokerC.start();
        long maxWaitMillis = 20000L;
        NetworkAsyncStartTest.assertTrue((String)"got bridge to C in 10 seconds", (boolean)this.waitForBridgeFormation(brokerA, 1, 7, 20000L));
    }

    private void bridgeBroker(BrokerService localBroker, String remoteURI) throws Exception {
        String uri = "static:(" + remoteURI + ")";
        DiscoveryNetworkConnector connector = new DiscoveryNetworkConnector(new URI(uri));
        connector.setName("bridge-" + this.bridgeCount++);
        localBroker.addNetworkConnector((NetworkConnector)connector);
    }

    @Override
    public void setUp() throws Exception {
        super.setAutoFail(true);
        super.setUp();
        this.createBroker(new URI("broker:()BrokerA?persistent=false&useJmx=false"));
        this.createBroker(new URI("broker:()BrokerB?persistent=false&useJmx=false"));
        this.createBroker(new URI("broker:()BrokerC?persistent=false&useJmx=false"));
    }

    static {
        System.setProperty("javax.net.ssl.trustStore", TRUST_KEYSTORE);
        System.setProperty("javax.net.ssl.trustStorePassword", PASSWORD);
        System.setProperty("javax.net.ssl.trustStoreType", KEYSTORE_TYPE);
        System.setProperty("javax.net.ssl.keyStore", SERVER_KEYSTORE);
        System.setProperty("javax.net.ssl.keyStoreType", KEYSTORE_TYPE);
        System.setProperty("javax.net.ssl.keyStorePassword", PASSWORD);
    }
}

