/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueSession;
import jakarta.jms.TextMessage;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXRemoveQueueThenSendIgnoredTest {
    private static final Logger LOG = LoggerFactory.getLogger(JMXRemoveQueueThenSendIgnoredTest.class);
    private static final String domain = "org.apache.activemq";
    private BrokerService brokerService;
    private MessageProducer producer;
    private QueueSession session;
    private QueueConnection connection;
    private Queue queue;
    private int count = 1;

    @Before
    public void setUp() throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setBrokerName("dev");
        this.brokerService.setPersistent(false);
        this.brokerService.setUseJmx(true);
        this.brokerService.addConnector("tcp://localhost:0");
        this.brokerService.start();
        String brokerUri = ((TransportConnector)this.brokerService.getTransportConnectors().get(0)).getPublishableConnectString();
        ActiveMQConnectionFactory activeMQConnectionFactory = new ActiveMQConnectionFactory(brokerUri);
        this.connection = activeMQConnectionFactory.createQueueConnection();
        this.session = this.connection.createQueueSession(true, 1);
        this.queue = this.session.createQueue("myqueue");
        this.producer = this.session.createProducer((Destination)this.queue);
        this.producer.setDeliveryMode(2);
        this.connection.start();
    }

    @Test
    public void testRemoveQueueAndProduceAfterNewConsumerAdded() throws Exception {
        MessageConsumer firstConsumer = this.registerConsumer();
        this.produceMessage();
        Message message = firstConsumer.receive(5000L);
        LOG.info("Received message " + message);
        Assert.assertEquals((long)1L, (long)this.numberOfMessages());
        firstConsumer.close();
        this.session.commit();
        Thread.sleep(1000L);
        this.removeQueue();
        Thread.sleep(1000L);
        MessageConsumer secondConsumer = this.registerConsumer();
        this.produceMessage();
        message = secondConsumer.receive(5000L);
        LOG.debug("Received message " + message);
        Assert.assertEquals((long)1L, (long)this.numberOfMessages());
        secondConsumer.close();
    }

    @Test
    public void testRemoveQueueAndProduceBeforeNewConsumerAdded() throws Exception {
        MessageConsumer firstConsumer = this.registerConsumer();
        this.produceMessage();
        Message message = firstConsumer.receive(5000L);
        LOG.info("Received message " + message);
        Assert.assertEquals((long)1L, (long)this.numberOfMessages());
        firstConsumer.close();
        this.session.commit();
        Thread.sleep(1000L);
        this.removeQueue();
        Thread.sleep(1000L);
        this.produceMessage();
        MessageConsumer secondConsumer = this.registerConsumer();
        message = secondConsumer.receive(5000L);
        LOG.debug("Received message " + message);
        Assert.assertEquals((long)1L, (long)this.numberOfMessages());
        secondConsumer.close();
    }

    private MessageConsumer registerConsumer() throws JMSException {
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        return consumer;
    }

    private int numberOfMessages() throws Exception {
        ObjectName queueViewMBeanName = new ObjectName("org.apache.activemq:destinationType=Queue,destinationName=myqueue,type=Broker,brokerName=dev");
        QueueViewMBean queue = (QueueViewMBean)this.brokerService.getManagementContext().newProxyInstance(queueViewMBeanName, QueueViewMBean.class, true);
        long size = queue.getQueueSize();
        return (int)size;
    }

    private void removeQueue() throws Exception {
        LOG.debug("Removing Destination: myqueue");
        this.brokerService.getAdminView().removeQueue("myqueue");
    }

    private void produceMessage() throws JMSException {
        TextMessage textMessage = this.session.createTextMessage();
        textMessage.setText("Sending message: " + this.count++);
        LOG.debug("Sending message: " + textMessage);
        this.producer.send((Message)textMessage);
        this.session.commit();
    }

    @After
    public void tearDown() throws Exception {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.brokerService.stop();
    }
}

