/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.store.memory.MemoryPersistenceAdapter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DurableSubscriptionOfflineTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(DurableSubscriptionOfflineTestBase.class);
    public boolean usePrioritySupport = Boolean.TRUE;
    public int journalMaxFileLength = 0x2000000;
    public boolean keepDurableSubsActive = true;
    protected BrokerService broker;
    protected ActiveMQTopic topic;
    protected final List<Throwable> exceptions = new ArrayList<Throwable>();
    protected ActiveMQConnectionFactory connectionFactory;
    protected boolean isTopic = true;
    public TestSupport.PersistenceAdapterChoice defaultPersistenceAdapter = TestSupport.PersistenceAdapterChoice.KahaDB;
    @Rule
    public TestName testName = new TestName();

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://" + this.getName(true));
        connectionFactory.setWatchTopicAdvisories(false);
        return connectionFactory;
    }

    protected Connection createConnection() throws Exception {
        return this.createConnection("cliName");
    }

    protected Connection createConnection(String name) throws Exception {
        ActiveMQConnectionFactory connectionFactory1 = this.createConnectionFactory();
        Connection connection = connectionFactory1.createConnection();
        connection.setClientID(name);
        connection.start();
        return connection;
    }

    public ActiveMQConnectionFactory getConnectionFactory() throws Exception {
        if (this.connectionFactory == null) {
            this.connectionFactory = this.createConnectionFactory();
            Assert.assertTrue((String)"Should have created a connection factory!", (this.connectionFactory != null ? 1 : 0) != 0);
        }
        return this.connectionFactory;
    }

    @Before
    public void setUp() throws Exception {
        this.exceptions.clear();
        this.topic = (ActiveMQTopic)this.createDestination();
        this.createBroker();
    }

    @After
    public void tearDown() throws Exception {
        this.destroyBroker();
    }

    protected void createBroker() throws Exception {
        this.createBroker(true);
    }

    protected void createBroker(boolean deleteAllMessages) throws Exception {
        String currentTestName = this.getName(true);
        this.broker = BrokerFactory.createBroker((String)("broker:(vm://" + currentTestName + ")"));
        this.broker.setBrokerName(currentTestName);
        this.broker.setDeleteAllMessagesOnStartup(deleteAllMessages);
        this.broker.getManagementContext().setCreateConnector(false);
        this.broker.setAdvisorySupport(false);
        this.broker.setKeepDurableSubsActive(this.keepDurableSubsActive);
        this.broker.addConnector("tcp://0.0.0.0:0");
        if (this.usePrioritySupport) {
            PolicyEntry policy = new PolicyEntry();
            policy.setPrioritizedMessages(true);
            PolicyMap policyMap = new PolicyMap();
            policyMap.setDefaultEntry(policy);
            this.broker.setDestinationPolicy(policyMap);
        }
        this.setDefaultPersistenceAdapter(this.broker);
        if (this.broker.getPersistenceAdapter() instanceof JDBCPersistenceAdapter) {
            ((JDBCPersistenceAdapter)this.broker.getPersistenceAdapter()).setCleanupPeriod(2000);
        } else if (this.broker.getPersistenceAdapter() instanceof KahaDBPersistenceAdapter) {
            ((KahaDBPersistenceAdapter)this.broker.getPersistenceAdapter()).setJournalMaxFileLength(this.journalMaxFileLength);
        }
        this.configurePlugins(this.broker);
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    public void configurePlugins(BrokerService broker) throws Exception {
    }

    protected void destroyBroker() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    protected Destination createDestination(String subject) {
        if (this.isTopic) {
            return new ActiveMQTopic(subject);
        }
        return new ActiveMQQueue(subject);
    }

    protected Destination createDestination() {
        return this.createDestination(this.getDestinationString());
    }

    protected String getDestinationString() {
        return this.getClass().getName() + "." + this.getName(true);
    }

    public String getName() {
        return this.getName(false);
    }

    protected String getName(boolean original) {
        String currentTestName = this.testName.getMethodName();
        currentTestName = currentTestName.replace("[", "");
        currentTestName = currentTestName.replace("]", "");
        return currentTestName;
    }

    public PersistenceAdapter setDefaultPersistenceAdapter(BrokerService broker) throws IOException {
        return this.setPersistenceAdapter(broker, this.defaultPersistenceAdapter);
    }

    public PersistenceAdapter setPersistenceAdapter(BrokerService broker, TestSupport.PersistenceAdapterChoice choice) throws IOException {
        JDBCPersistenceAdapter adapter = null;
        switch (choice) {
            case JDBC: {
                LOG.debug(">>>> setPersistenceAdapter to JDBC ");
                adapter = new JDBCPersistenceAdapter();
                break;
            }
            case KahaDB: {
                LOG.debug(">>>> setPersistenceAdapter to KahaDB ");
                adapter = new KahaDBPersistenceAdapter();
                break;
            }
            case MEM: {
                LOG.debug(">>>> setPersistenceAdapter to MEM ");
                adapter = new MemoryPersistenceAdapter();
            }
        }
        broker.setPersistenceAdapter(adapter);
        return adapter;
    }
}

