/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Session;
import java.util.HashMap;
import org.apache.activemq.test.TestSupport;

public class ChangeSentMessageTest
extends TestSupport {
    private static final int COUNT = 200;
    private static final String VALUE_NAME = "value";

    public void testDoChangeSentMessage() throws Exception {
        int i;
        Destination destination = this.createDestination("test-" + ChangeSentMessageTest.class.getName());
        Connection connection = this.createConnection();
        connection.start();
        Session consumerSession = connection.createSession(false, 1);
        MessageConsumer consumer = consumerSession.createConsumer(destination);
        Session publisherSession = connection.createSession(false, 1);
        MessageProducer producer = publisherSession.createProducer(destination);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        ObjectMessage message = publisherSession.createObjectMessage();
        for (i = 0; i < 200; ++i) {
            map.put(VALUE_NAME, i);
            message.setObject(map);
            producer.send((Message)message);
            ChangeSentMessageTest.assertTrue((message.getObject() == map ? 1 : 0) != 0);
        }
        for (i = 0; i < 200; ++i) {
            ObjectMessage msg = (ObjectMessage)consumer.receive();
            HashMap receivedMap = (HashMap)msg.getObject();
            Integer intValue = (Integer)receivedMap.get(VALUE_NAME);
            ChangeSentMessageTest.assertTrue((intValue == i ? 1 : 0) != 0);
        }
    }

    static {
        System.setProperty("org.apache.activemq.SERIALIZABLE_PACKAGES", "java.util,java.lang");
    }
}

