/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usage;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.io.File;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.util.IOHelper;
import org.apache.activemq.util.ProducerThread;
import org.apache.activemq.util.Wait;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobSchedulerStoreUsageTest
extends EmbeddedBrokerTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(JobSchedulerStoreUsageTest.class);
    final int WAIT_TIME_MILLS = 20000;

    @Override
    protected BrokerService createBroker() throws Exception {
        File schedulerDirectory = new File("target/scheduler");
        IOHelper.mkdirs((File)schedulerDirectory);
        IOHelper.deleteChildren((File)schedulerDirectory);
        BrokerService broker = super.createBroker();
        broker.setSchedulerSupport(true);
        broker.setSchedulerDirectoryFile(schedulerDirectory);
        broker.getSystemUsage().getJobSchedulerUsage().setLimit(7168L);
        broker.deleteAllMessages();
        return broker;
    }

    @Override
    protected boolean isPersistent() {
        return true;
    }

    public void testBlockAndChangeViaJmxReleases() throws Exception {
        LOG.info("Initial scheduler usage: {}", (Object)this.broker.getAdminView().getJobSchedulerStorePercentUsage());
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
        Connection conn = factory.createConnection();
        conn.start();
        Session sess = conn.createSession(false, 1);
        Queue dest = sess.createQueue(((Object)((Object)this)).getClass().getName());
        final ProducerThread producer = new ProducerThread(sess, (Destination)dest){

            protected Message createMessage(int i) throws Exception {
                Message message = super.createMessage(i);
                message.setLongProperty("AMQ_SCHEDULED_DELAY", 10000L);
                return message;
            }
        };
        producer.setMessageCount(100);
        producer.start();
        JobSchedulerStoreUsageTest.assertEquals((long)7168L, (long)this.broker.getAdminView().getJobSchedulerStoreLimit());
        JobSchedulerStoreUsageTest.assertTrue((String)"Usage exhausted", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                LOG.info("scheduler store usage %" + JobSchedulerStoreUsageTest.this.broker.getAdminView().getJobSchedulerStorePercentUsage() + " producerSent count:" + producer.getSentCount());
                return JobSchedulerStoreUsageTest.this.broker.getAdminView().getJobSchedulerStorePercentUsage() > 100;
            }
        }));
        LOG.info("scheduler store usage %" + this.broker.getAdminView().getJobSchedulerStorePercentUsage() + " producerSent count:" + producer.getSentCount());
        Assert.assertNotEquals((String)"Producer has not sent all messages", (long)producer.getMessageCount(), (long)producer.getSentCount());
        this.broker.getAdminView().setJobSchedulerStoreLimit(0x2100000L);
        LOG.info("scheduler store usage %" + this.broker.getAdminView().getJobSchedulerStorePercentUsage() + " producerSent count:" + producer.getSentCount());
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return producer.getSentCount() == producer.getMessageCount();
            }
        });
        JobSchedulerStoreUsageTest.assertEquals((String)"Producer sent all messages", (int)producer.getMessageCount(), (int)producer.getSentCount());
        JobSchedulerStoreUsageTest.assertTrue((this.broker.getAdminView().getJobSchedulerStorePercentUsage() < 100 ? 1 : 0) != 0);
    }
}

