/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.reliable;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.transport.reliable.DropCommandStrategy;
import org.apache.activemq.transport.reliable.ReplayBuffer;
import org.apache.activemq.transport.udp.ByteBufferPool;
import org.apache.activemq.transport.udp.CommandDatagramChannel;
import org.apache.activemq.transport.udp.DatagramHeaderMarshaller;
import org.apache.activemq.transport.udp.UdpTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnreliableCommandDatagramChannel
extends CommandDatagramChannel {
    private static final Logger LOG = LoggerFactory.getLogger(UnreliableCommandDatagramChannel.class);
    private DropCommandStrategy dropCommandStrategy;

    public UnreliableCommandDatagramChannel(UdpTransport transport, OpenWireFormat wireFormat, int datagramSize, SocketAddress targetAddress, DatagramHeaderMarshaller headerMarshaller, ReplayBuffer replayBuffer, DatagramChannel channel, ByteBufferPool bufferPool, DropCommandStrategy strategy) {
        super(transport, wireFormat, datagramSize, targetAddress, headerMarshaller, channel, bufferPool);
        this.dropCommandStrategy = strategy;
    }

    protected void sendWriteBuffer(int commandId, SocketAddress address, ByteBuffer writeBuffer, boolean redelivery) throws IOException {
        if (this.dropCommandStrategy.shouldDropCommand(commandId, address, redelivery)) {
            writeBuffer.flip();
            LOG.info("Dropping datagram with command: " + commandId);
            this.getReplayBuffer().addBuffer(commandId, (Object)writeBuffer);
        } else {
            super.sendWriteBuffer(commandId, address, writeBuffer, redelivery);
        }
    }
}

