/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.XAConnection;
import jakarta.jms.XASession;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.xa.Xid;
import org.apache.activemq.ActiveMQXAConnectionFactory;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerPluginSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.util.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverXATransactionTest {
    private static final Logger LOG = LoggerFactory.getLogger(FailoverXATransactionTest.class);
    private static final String QUEUE_NAME = "Failover.WithXaTx";
    private static final String TRANSPORT_URI = "tcp://localhost:0";
    private String url;
    BrokerService broker;

    @After
    public void stopBroker() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
            this.broker.waitUntilStopped();
        }
    }

    public void startBroker(boolean deleteAllMessagesOnStartup) throws Exception {
        this.broker = this.createBroker(deleteAllMessagesOnStartup);
        this.broker.start();
    }

    public void startBroker(boolean deleteAllMessagesOnStartup, String bindAddress) throws Exception {
        this.broker = this.createBroker(deleteAllMessagesOnStartup, bindAddress);
        this.broker.start();
    }

    public BrokerService createBroker(boolean deleteAllMessagesOnStartup) throws Exception {
        return this.createBroker(deleteAllMessagesOnStartup, TRANSPORT_URI);
    }

    public BrokerService createBroker(boolean deleteAllMessagesOnStartup, String bindAddress) throws Exception {
        this.broker = new BrokerService();
        this.broker.setUseJmx(true);
        this.broker.setAdvisorySupport(false);
        this.broker.addConnector(bindAddress);
        this.broker.setDeleteAllMessagesOnStartup(deleteAllMessagesOnStartup);
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry defaultEntry = new PolicyEntry();
        defaultEntry.setUsePrefetchExtension(false);
        policyMap.setDefaultEntry(defaultEntry);
        this.broker.setDestinationPolicy(policyMap);
        this.url = ((TransportConnector)this.broker.getTransportConnectors().get(0)).getConnectUri().toString();
        return this.broker;
    }

    @Test
    public void testFailoverSendPrepareReplyLost() throws Exception {
        this.broker = this.createBroker(true);
        final AtomicBoolean first = new AtomicBoolean(false);
        this.broker.setPlugins(new BrokerPlugin[]{new BrokerPluginSupport(){

            public int prepareTransaction(final ConnectionContext context, TransactionId xid) throws Exception {
                int result = super.prepareTransaction(context, xid);
                if (first.compareAndSet(false, true)) {
                    context.setDontSendReponse(true);
                    Executors.newSingleThreadExecutor().execute(new Runnable(){

                        @Override
                        public void run() {
                            LOG.info("Stopping broker on prepare");
                            try {
                                context.getConnection().stop();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
                return result;
            }
        }});
        this.broker.start();
        ActiveMQXAConnectionFactory cf = new ActiveMQXAConnectionFactory("failover:(" + this.url + ")");
        XAConnection connection = cf.createXAConnection();
        connection.start();
        XASession session = connection.createXASession();
        Queue destination = session.createQueue(QUEUE_NAME);
        Xid xid = TestUtils.createXid();
        session.getXAResource().start(xid, 0);
        this.produceMessage((Session)session, destination);
        session.getXAResource().end(xid, 0x4000000);
        try {
            session.getXAResource().prepare(xid);
        }
        catch (Exception expected) {
            expected.printStackTrace();
        }
        try {
            session.getXAResource().rollback(xid);
        }
        catch (Exception expected) {
            expected.printStackTrace();
        }
        connection.close();
        Assert.assertEquals((long)0L, (long)this.broker.getAdminView().getTotalMessageCount());
    }

    @Test
    public void testFailoverSendCommitReplyLost() throws Exception {
        this.broker = this.createBroker(true);
        final AtomicBoolean first = new AtomicBoolean(false);
        this.broker.setPlugins(new BrokerPlugin[]{new BrokerPluginSupport(){

            public void commitTransaction(final ConnectionContext context, TransactionId xid, boolean onePhase) throws Exception {
                super.commitTransaction(context, xid, onePhase);
                if (first.compareAndSet(false, true)) {
                    context.setDontSendReponse(true);
                    Executors.newSingleThreadExecutor().execute(new Runnable(){

                        @Override
                        public void run() {
                            LOG.info("Stopping broker on prepare");
                            try {
                                context.getConnection().stop();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
            }
        }});
        this.broker.start();
        ActiveMQXAConnectionFactory cf = new ActiveMQXAConnectionFactory("failover:(" + this.url + ")");
        XAConnection connection = cf.createXAConnection();
        connection.start();
        XASession session = connection.createXASession();
        Queue destination = session.createQueue(QUEUE_NAME);
        Xid xid = TestUtils.createXid();
        session.getXAResource().start(xid, 0);
        this.produceMessage((Session)session, destination);
        session.getXAResource().end(xid, 0x4000000);
        try {
            session.getXAResource().prepare(xid);
        }
        catch (Exception expected) {
            expected.printStackTrace();
        }
        try {
            session.getXAResource().commit(xid, false);
        }
        catch (Exception expected) {
            expected.printStackTrace();
        }
        connection.close();
        Assert.assertEquals((long)1L, (long)this.broker.getAdminView().getTotalMessageCount());
    }

    private void produceMessage(Session producerSession, Queue destination) throws JMSException {
        MessageProducer producer = producerSession.createProducer((Destination)destination);
        TextMessage message = producerSession.createTextMessage("Test message");
        producer.send((Message)message);
        producer.close();
    }
}

