/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQMessageConsumer;
import org.apache.activemq.ActiveMQMessageTransformation;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerPluginSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.SessionId;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverConsumerUnconsumedTest {
    private static final Logger LOG = LoggerFactory.getLogger(FailoverConsumerUnconsumedTest.class);
    private static final String QUEUE_NAME = "FailoverWithUnconsumed";
    private static final String TRANSPORT_URI = "tcp://localhost:0";
    private String url;
    final int prefetch = 10;
    BrokerService broker;
    static long idGen = 100L;

    @After
    public void stopBroker() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    public void startBroker(boolean deleteAllMessagesOnStartup) throws Exception {
        this.broker = this.createBroker(deleteAllMessagesOnStartup);
        this.broker.start();
    }

    public BrokerService createBroker(boolean deleteAllMessagesOnStartup) throws Exception {
        return this.createBroker(deleteAllMessagesOnStartup, TRANSPORT_URI);
    }

    public BrokerService createBroker(boolean deleteAllMessagesOnStartup, String bindAddress) throws Exception {
        this.broker = new BrokerService();
        this.broker.addConnector(bindAddress);
        this.broker.setDeleteAllMessagesOnStartup(deleteAllMessagesOnStartup);
        this.url = ((TransportConnector)this.broker.getTransportConnectors().get(0)).getConnectUri().toString();
        return this.broker;
    }

    @Test
    public void testFailoverConsumerDups() throws Exception {
        this.doTestFailoverConsumerDups(true);
    }

    @Test
    public void testFailoverConsumerDupsNoAdvisoryWatch() throws Exception {
        this.doTestFailoverConsumerDups(false);
    }

    @Test
    public void testFailoverClientAckMissingRedelivery() throws Exception {
        int maxConsumers = 2;
        this.broker = this.createBroker(true);
        this.broker.setPlugins(new BrokerPlugin[]{new BrokerPluginSupport(){
            int consumerCount;

            public Subscription addConsumer(ConnectionContext context, final ConsumerInfo info) throws Exception {
                if (++this.consumerCount == 2) {
                    context.setDontSendReponse(true);
                    Executors.newSingleThreadExecutor().execute(new Runnable(){

                        @Override
                        public void run() {
                            LOG.info("Stopping broker on consumer: " + info.getConsumerId());
                            try {
                                FailoverConsumerUnconsumedTest.this.broker.stop();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
                return super.addConsumer(context, info);
            }
        }});
        this.broker.start();
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("failover:(" + this.url + ")");
        cf.setWatchTopicAdvisories(false);
        final ActiveMQConnection connection = (ActiveMQConnection)cf.createConnection();
        connection.start();
        final Session consumerSession = connection.createSession(false, 2);
        final Queue destination = consumerSession.createQueue("FailoverWithUnconsumed?jms.consumer.prefetch=10");
        final Vector<TestConsumer> testConsumers = new Vector<TestConsumer>();
        TestConsumer testConsumer = new TestConsumer(consumerSession, (Destination)destination, connection);
        testConsumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                try {
                    LOG.info("onMessage:" + message.getJMSMessageID());
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
        });
        testConsumers.add(testConsumer);
        this.produceMessage(consumerSession, destination, 20L);
        Assert.assertTrue((String)"add messages are delivered", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                int totalDelivered = 0;
                for (TestConsumer testConsumer : testConsumers) {
                    long delivered = testConsumer.deliveredSize();
                    LOG.info(testConsumer.getConsumerId() + " delivered: " + delivered);
                    totalDelivered = (int)((long)totalDelivered + delivered);
                }
                return totalDelivered == 20;
            }
        }));
        final CountDownLatch shutdownConsumerAdded = new CountDownLatch(1);
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    LOG.info("add last consumer...");
                    TestConsumer testConsumer = new TestConsumer(consumerSession, (Destination)destination, connection);
                    testConsumer.setMessageListener(new MessageListener(){

                        public void onMessage(Message message) {
                            try {
                                LOG.info("onMessage:" + message.getJMSMessageID());
                            }
                            catch (JMSException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    testConsumers.add(testConsumer);
                    shutdownConsumerAdded.countDown();
                    LOG.info("done add last consumer");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.broker.waitUntilStopped();
        this.broker = this.createBroker(false, this.url);
        this.broker.start();
        Assert.assertTrue((String)"consumer added through failover", (boolean)shutdownConsumerAdded.await(30L, TimeUnit.SECONDS));
        Assert.assertTrue((String)"after restart all messages are re dispatched", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                int totalDelivered = 0;
                for (TestConsumer testConsumer : testConsumers) {
                    long delivered = testConsumer.deliveredSize();
                    LOG.info(testConsumer.getConsumerId() + " delivered: " + delivered);
                    totalDelivered = (int)((long)totalDelivered + delivered);
                }
                return totalDelivered == 20;
            }
        }));
        Assert.assertTrue((String)"after restart each got prefetch amount", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                for (TestConsumer testConsumer : testConsumers) {
                    long delivered = testConsumer.deliveredSize();
                    LOG.info(testConsumer.getConsumerId() + " delivered: " + delivered);
                    if (delivered == 10L) continue;
                    return false;
                }
                return true;
            }
        }));
        connection.close();
    }

    public void doTestFailoverConsumerDups(final boolean watchTopicAdvisories) throws Exception {
        int maxConsumers = 4;
        this.broker = this.createBroker(true);
        this.broker.setPlugins(new BrokerPlugin[]{new BrokerPluginSupport(){
            int consumerCount;

            public Subscription addConsumer(ConnectionContext context, final ConsumerInfo info) throws Exception {
                if (++this.consumerCount == 4 + (watchTopicAdvisories ? 1 : 0)) {
                    context.setDontSendReponse(true);
                    Executors.newSingleThreadExecutor().execute(new Runnable(){

                        @Override
                        public void run() {
                            LOG.info("Stopping broker on consumer: " + info.getConsumerId());
                            try {
                                FailoverConsumerUnconsumedTest.this.broker.stop();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
                return super.addConsumer(context, info);
            }
        }});
        this.broker.start();
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("failover:(" + this.url + ")");
        cf.setWatchTopicAdvisories(watchTopicAdvisories);
        final ActiveMQConnection connection = (ActiveMQConnection)cf.createConnection();
        connection.start();
        final Session consumerSession = connection.createSession(false, 1);
        final Queue destination = consumerSession.createQueue("FailoverWithUnconsumed?jms.consumer.prefetch=10");
        final Vector<TestConsumer> testConsumers = new Vector<TestConsumer>();
        for (int i = 0; i < 3; ++i) {
            testConsumers.add(new TestConsumer(consumerSession, (Destination)destination, connection));
        }
        this.produceMessage(consumerSession, destination, 40L);
        Assert.assertTrue((String)"add messages are dispatched", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                int totalUnconsumed = 0;
                for (TestConsumer testConsumer : testConsumers) {
                    long unconsumed = testConsumer.unconsumedSize();
                    LOG.info(testConsumer.getConsumerId() + " unconsumed: " + unconsumed);
                    totalUnconsumed = (int)((long)totalUnconsumed + unconsumed);
                }
                return totalUnconsumed == 30;
            }
        }));
        final CountDownLatch shutdownConsumerAdded = new CountDownLatch(1);
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    LOG.info("add last consumer...");
                    testConsumers.add(new TestConsumer(consumerSession, (Destination)destination, connection));
                    shutdownConsumerAdded.countDown();
                    LOG.info("done add last consumer");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.broker.waitUntilStopped();
        Assert.assertTrue((String)"add messages dispatched and unconsumed are cleaned up", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                int totalUnconsumed = 0;
                for (TestConsumer testConsumer : testConsumers) {
                    long unconsumed = testConsumer.unconsumedSize();
                    LOG.info(testConsumer.getConsumerId() + " unconsumed: " + unconsumed);
                    totalUnconsumed = (int)((long)totalUnconsumed + unconsumed);
                }
                return totalUnconsumed == 0;
            }
        }));
        this.broker = this.createBroker(false, this.url);
        this.broker.start();
        Assert.assertTrue((String)"consumer added through failover", (boolean)shutdownConsumerAdded.await(30L, TimeUnit.SECONDS));
        Assert.assertTrue((String)"after start all messages are re dispatched", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                int totalUnconsumed = 0;
                for (TestConsumer testConsumer : testConsumers) {
                    long unconsumed = testConsumer.unconsumedSize();
                    LOG.info(testConsumer.getConsumerId() + " after restart: unconsumed: " + unconsumed);
                    totalUnconsumed = (int)((long)totalUnconsumed + unconsumed);
                }
                return totalUnconsumed == 40;
            }
        }));
        connection.close();
    }

    private void produceMessage(Session producerSession, Queue destination, long count) throws JMSException {
        MessageProducer producer = producerSession.createProducer((Destination)destination);
        int i = 0;
        while ((long)i < count) {
            TextMessage message = producerSession.createTextMessage("Test message " + i);
            producer.send((Message)message);
            ++i;
        }
        producer.close();
    }

    private static long nextGen() {
        return idGen -= 5L;
    }

    class TestConsumer
    extends ActiveMQMessageConsumer {
        TestConsumer(Session consumerSession, Destination destination, ActiveMQConnection connection) throws Exception {
            super((ActiveMQSession)consumerSession, new ConsumerId(new SessionId(connection.getConnectionInfo().getConnectionId(), 1L), FailoverConsumerUnconsumedTest.nextGen()), ActiveMQMessageTransformation.transformDestination((Destination)destination), null, "", 10, -1, false, false, true, null);
        }

        public int unconsumedSize() {
            return this.unconsumedMessages.size();
        }

        public int deliveredSize() {
            return this.deliveredMessages.size();
        }
    }
}

