/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.auto;

import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnection;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.openwire.OpenWireFormat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AutoWireFormatConfigurationTest {
    public static final String KEYSTORE_TYPE = "jks";
    public static final String PASSWORD = "password";
    public static final String SERVER_KEYSTORE = "src/test/resources/server.keystore";
    public static final String TRUST_KEYSTORE = "src/test/resources/client.keystore";
    private String uri;
    private final String protocol;
    private BrokerService brokerService;
    private final boolean onlyScheme;

    @Parameterized.Parameters(name="protocol={0},onlyScheme={1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"auto", true}, {"auto+nio", true}, {"auto+nio+ssl", true}, {"auto+ssl", true}, {"auto", false}, {"auto+nio", false}, {"auto+nio+ssl", false}, {"auto+ssl", false});
    }

    @Before
    public void before() throws Exception {
        BrokerService brokerService = new BrokerService();
        brokerService.setPersistent(false);
        String wireFormatSetting = this.onlyScheme ? "wireFormat.default.cacheEnabled=false" : "wireFormat.cacheEnabled=false";
        TransportConnector connector = brokerService.addConnector(this.protocol + "://localhost:0?" + wireFormatSetting);
        connector.setName("auto");
        this.uri = connector.getPublishableConnectString();
        this.brokerService = brokerService;
        brokerService.start();
        brokerService.waitUntilStarted();
    }

    @After
    public void after() throws Exception {
        if (this.brokerService != null) {
            this.brokerService.stop();
            this.brokerService.waitUntilStopped();
        }
    }

    public AutoWireFormatConfigurationTest(String protocol, boolean onlyScheme) {
        this.protocol = protocol;
        this.onlyScheme = onlyScheme;
    }

    @Test(timeout=10000L)
    public void testConnect() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
        factory.setBrokerURL(this.uri);
        for (int i = 0; i < 5; ++i) {
            factory.createConnection().start();
        }
        for (TransportConnection connection : this.brokerService.getTransportConnectorByName("auto").getConnections()) {
            OpenWireFormat wireFormat = (OpenWireFormat)connection.getTransport().getWireFormat();
            Assert.assertEquals((Object)false, (Object)wireFormat.isCacheEnabled());
        }
    }

    static {
        System.setProperty("javax.net.ssl.trustStore", TRUST_KEYSTORE);
        System.setProperty("javax.net.ssl.trustStorePassword", PASSWORD);
        System.setProperty("javax.net.ssl.trustStoreType", KEYSTORE_TYPE);
        System.setProperty("javax.net.ssl.keyStore", SERVER_KEYSTORE);
        System.setProperty("javax.net.ssl.keyStorePassword", PASSWORD);
        System.setProperty("javax.net.ssl.keyStoreType", KEYSTORE_TYPE);
    }
}

