/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.auto;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.util.Arrays;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AutoTransportConfigureTest {
    public static final String KEYSTORE_TYPE = "jks";
    public static final String PASSWORD = "password";
    public static final String SERVER_KEYSTORE = "src/test/resources/server.keystore";
    public static final String TRUST_KEYSTORE = "src/test/resources/client.keystore";
    private BrokerService brokerService;
    private String url;
    private String transportType;

    @Parameterized.Parameters
    public static Iterable<Object[]> parameters() {
        return Arrays.asList({"auto"}, {"auto+nio"}, {"auto+ssl"}, {"auto+nio+ssl"});
    }

    public AutoTransportConfigureTest(String transportType) {
        this.transportType = transportType;
    }

    @Before
    public void setUp() throws Exception {
        System.setProperty("javax.net.ssl.trustStore", TRUST_KEYSTORE);
        System.setProperty("javax.net.ssl.trustStorePassword", PASSWORD);
        System.setProperty("javax.net.ssl.trustStoreType", KEYSTORE_TYPE);
        System.setProperty("javax.net.ssl.keyStore", SERVER_KEYSTORE);
        System.setProperty("javax.net.ssl.keyStorePassword", PASSWORD);
        System.setProperty("javax.net.ssl.keyStoreType", KEYSTORE_TYPE);
    }

    @After
    public void tearDown() throws Exception {
        if (this.brokerService != null) {
            this.brokerService.stop();
            this.brokerService.waitUntilStopped();
        }
    }

    protected void createBroker(String uriConfig) throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setPersistent(false);
        this.url = this.brokerService.addConnector(uriConfig).getPublishableConnectString();
        this.brokerService.start();
        this.brokerService.waitUntilStarted();
    }

    @Test(expected=JMSException.class)
    public void testUrlConfiguration() throws Exception {
        this.createBroker(this.transportType + "://localhost:0?wireFormat.maxFrameSize=10");
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.url);
        this.sendMessage(factory.createConnection());
    }

    @Test(expected=JMSException.class)
    public void testUrlConfigurationOpenWireFail() throws Exception {
        this.createBroker(this.transportType + "://localhost:0?wireFormat.default.maxFrameSize=10");
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.url);
        this.sendMessage(factory.createConnection());
    }

    @Test
    public void testUrlConfigurationOpenWireSuccess() throws Exception {
        this.createBroker(this.transportType + "://localhost:0?wireFormat.stomp.maxFrameSize=10");
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.url);
        this.sendMessage(factory.createConnection());
    }

    @Test(expected=JMSException.class)
    public void testUrlConfigurationOpenWireNotAvailable() throws Exception {
        this.createBroker(this.transportType + "://localhost:0?auto.protocols=stomp");
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.url);
        this.sendMessage(factory.createConnection());
    }

    @Test
    public void testUrlConfigurationOpenWireAvailable() throws Exception {
        this.createBroker(this.transportType + "://localhost:0?auto.protocols=default");
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.url);
        this.sendMessage(factory.createConnection());
    }

    @Test
    public void testUrlConfigurationOpenWireAndAmqpAvailable() throws Exception {
        this.createBroker(this.transportType + "://localhost:0?auto.protocols=default,stomp");
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.url);
        this.sendMessage(factory.createConnection());
    }

    protected void sendMessage(Connection connection) throws JMSException {
        connection.start();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)new ActiveMQQueue("test"));
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        message.setText("this is a test");
        producer.send((Message)message);
    }
}

