/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import java.util.concurrent.ThreadPoolExecutor;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.MaxFrameSizeExceededException;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.transport.nio.SelectorManager;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MaxFrameSizeEnabledTest {
    public static final String KEYSTORE_TYPE = "jks";
    public static final String PASSWORD = "password";
    public static final String SERVER_KEYSTORE = "src/test/resources/org/apache/activemq/security/broker1.ks";
    public static final String TRUST_KEYSTORE = "src/test/resources/org/apache/activemq/security/broker1.ks";
    private BrokerService broker;
    private final String transportType;
    private final boolean clientSideEnabled;
    private final boolean clientSideFailoverEnabled;
    private final boolean serverSideEnabled;

    public MaxFrameSizeEnabledTest(String transportType, boolean clientSideEnabled, boolean clientSideFailoverEnabled, boolean serverSideEnabled) {
        this.transportType = transportType;
        this.clientSideEnabled = clientSideEnabled;
        this.clientSideFailoverEnabled = clientSideFailoverEnabled;
        this.serverSideEnabled = serverSideEnabled;
    }

    @Parameterized.Parameters(name="transportType={0},clientSideEnable={1},clientSideFailoverEnable={2},serverSideEnabled={3}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"tcp", true, false, true}, {"tcp", true, true, true}, {"ssl", true, false, true}, {"ssl", true, true, true}, {"nio", true, false, true}, {"nio", true, true, true}, {"nio+ssl", true, false, true}, {"nio+ssl", true, true, true}, {"auto", true, false, true}, {"auto", true, true, true}, {"auto+ssl", true, false, true}, {"auto+ssl", true, true, true}, {"auto+nio", true, false, true}, {"auto+nio", true, true, true}, {"auto+nio+ssl", true, false, true}, {"auto+nio+ssl", true, true, true}, {"tcp", true, false, false}, {"tcp", true, true, false}, {"ssl", true, false, false}, {"ssl", true, true, false}, {"nio", true, false, false}, {"nio", true, true, false}, {"nio+ssl", true, false, false}, {"nio+ssl", true, true, false}, {"auto", true, false, false}, {"auto", true, true, false}, {"auto+ssl", true, false, false}, {"auto+ssl", true, true, false}, {"auto+nio", true, false, false}, {"auto+nio", true, true, false}, {"auto+nio+ssl", true, false, false}, {"auto+nio+ssl", true, true, false}, {"tcp", false, false, true}, {"ssl", false, false, true}, {"nio", false, false, true}, {"nio+ssl", false, false, true}, {"auto", false, false, true}, {"auto+ssl", false, false, true}, {"auto+nio", false, false, true}, {"auto+nio+ssl", false, false, true}, {"tcp", false, false, false}, {"tcp", false, true, false}, {"ssl", false, false, false}, {"ssl", false, true, false}, {"nio", false, false, false}, {"nio", false, true, false}, {"nio+ssl", false, false, false}, {"nio+ssl", false, true, false}, {"auto", false, false, false}, {"auto", false, true, false}, {"auto+ssl", false, false, false}, {"auto+ssl", false, true, false}, {"auto+nio", false, false, false}, {"auto+nio", false, true, false}, {"auto+nio+ssl", false, false, false}, {"auto+nio+ssl", false, true, false});
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        System.setProperty("javax.net.ssl.trustStore", "src/test/resources/org/apache/activemq/security/broker1.ks");
        System.setProperty("javax.net.ssl.trustStorePassword", PASSWORD);
        System.setProperty("javax.net.ssl.trustStoreType", KEYSTORE_TYPE);
        System.setProperty("javax.net.ssl.keyStore", "src/test/resources/org/apache/activemq/security/broker1.ks");
        System.setProperty("javax.net.ssl.keyStoreType", KEYSTORE_TYPE);
        System.setProperty("javax.net.ssl.keyStorePassword", PASSWORD);
    }

    @After
    public void after() throws Exception {
        this.stopBroker(this.broker);
    }

    public BrokerService createBroker(String connectorName, String connectorString) throws Exception {
        BrokerService broker = new BrokerService();
        broker.setPersistent(false);
        broker.setUseJmx(false);
        TransportConnector connector = broker.addConnector(connectorString);
        connector.setName(connectorName);
        broker.start();
        broker.waitUntilStarted();
        return broker;
    }

    public void stopBroker(BrokerService broker) throws Exception {
        if (broker != null) {
            broker.stop();
            broker.waitUntilStopped();
        }
    }

    @Test
    public void testMaxFrameSize() throws Exception {
        this.broker = this.createBroker(this.transportType, this.transportType + "://localhost:0?wireFormat.maxFrameSize=2048" + this.getServerParams());
        this.testMaxFrameSize(this.transportType, this.getClientUri(this.broker.getConnectorByName(this.transportType).getConnectUri().getPort()), false);
    }

    @Test
    public void testMaxFrameSizeCompression() throws Exception {
        this.broker = this.createBroker(this.transportType, this.transportType + "://localhost:0?wireFormat.maxFrameSize=60000" + this.getServerParams());
        this.testMaxFrameSize(this.transportType, this.getClientUri(this.broker.getConnectorByName(this.transportType).getConnectUri().getPort()), true);
    }

    protected void testMaxFrameSize(String transportType, String clientUri, boolean useCompression) throws Exception {
        int i;
        ArrayList<Connection> connections = new ArrayList<Connection>();
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(clientUri);
        factory.setUseCompression(useCompression);
        for (int i2 = 0; i2 < 10; ++i2) {
            Connection connection = factory.createConnection();
            connection.start();
            connections.add(connection);
        }
        StringBuffer body = new StringBuffer();
        Random r = new Random();
        for (i = 0; i < 10000; ++i) {
            body.append(r.nextInt());
        }
        for (i = 0; i < 10; ++i) {
            boolean maxFrameSizeException = false;
            boolean otherException = false;
            Connection connection = null;
            Session session = null;
            Queue destination = null;
            MessageConsumer messageConsumer = null;
            MessageProducer producer = null;
            try {
                connection = (Connection)connections.get(i);
                session = connection.createSession(false, 1);
                destination = session.createQueue("TEST");
                producer = session.createProducer((Destination)destination);
                producer.send((Message)session.createTextMessage(body.toString()));
            }
            catch (JMSException e) {
                if (this.clientSideEnabled) {
                    Assert.assertNotNull((Object)e.getErrorCode());
                    Assert.assertEquals((Object)"41300", (Object)e.getErrorCode());
                    TestCase.assertTrue((boolean)(e.getCause() instanceof MaxFrameSizeExceededException));
                } else {
                    TestCase.assertTrue((boolean)(e.getCause() instanceof IOException));
                }
                Assert.assertNotNull((Object)e.getCause());
                maxFrameSizeException = true;
            }
            catch (Exception e) {
                otherException = true;
            }
            if (this.maxFrameSizeEnabled() && !useCompression) {
                TestCase.assertTrue((String)"Should have gotten a jms maxframesize exception", (boolean)maxFrameSizeException);
                Assert.assertFalse((String)"Should not have gotten a transport exception", (boolean)otherException);
            } else {
                Assert.assertFalse((String)"Should not have gotten a jms maxframesize exception", (boolean)maxFrameSizeException);
            }
            if (!this.maxFrameSizeEnabled() && otherException) {
                Assert.fail((String)"Should not have gotten exception");
            }
            Assert.assertNotNull((Object)connection);
            Assert.assertNotNull((Object)session);
            Assert.assertNotNull((Object)destination);
            Assert.assertNotNull((Object)producer);
            if (!this.connectionsShouldBeOpen(useCompression)) continue;
            boolean nextException = false;
            try {
                messageConsumer = session.createConsumer((Destination)destination);
                producer.send((Message)session.createTextMessage("Hello"));
                int maxLoops = 50;
                boolean found = false;
                do {
                    Message message;
                    if ((message = messageConsumer.receive(200L)) == null) continue;
                    TestCase.assertTrue((boolean)TextMessage.class.isAssignableFrom(message.getClass()));
                    ((TextMessage)TextMessage.class.cast(message)).getText().equals("Hello");
                    found = true;
                } while (!found && ++maxLoops <= 50);
            }
            catch (Exception e) {
                nextException = true;
            }
            Assert.assertFalse((String)"Should not have gotten an exception for the next message", (boolean)nextException);
        }
        if (this.connectionsShouldBeOpen(useCompression)) {
            TestCase.assertTrue((boolean)Wait.waitFor(() -> this.broker.getConnectorByName(transportType).getConnections().size() == 10, (long)3000L, (long)500L));
        } else {
            TestCase.assertTrue((boolean)Wait.waitFor(() -> this.broker.getConnectorByName(transportType).getConnections().size() == 0, (long)3000L, (long)500L));
        }
        if (this.isNio() && this.connectionsShouldBeOpen(useCompression)) {
            ThreadPoolExecutor e = (ThreadPoolExecutor)SelectorManager.getInstance().getSelectorExecutor();
            TestCase.assertTrue((boolean)Wait.waitFor(() -> e.getActiveCount() == 1, (long)3000L, (long)500L));
        }
    }

    private boolean maxFrameSizeEnabled() {
        return this.clientSideEnabled || this.serverSideEnabled;
    }

    private boolean connectionsShouldBeOpen(boolean useCompression) {
        return !this.maxFrameSizeEnabled() || this.clientSideEnabled || useCompression;
    }

    private boolean isFailover() {
        return this.clientSideFailoverEnabled;
    }

    private boolean isSsl() {
        return this.transportType.contains("ssl");
    }

    private boolean isNio() {
        return this.transportType.contains("nio");
    }

    private String getServerParams() {
        if (this.serverSideEnabled) {
            return this.isSsl() ? "&transport.needClientAuth=true" : "";
        }
        return this.isSsl() ? "&transport.needClientAuth=true&wireFormat.maxFrameSizeEnabled=false" : "&wireFormat.maxFrameSizeEnabled=false";
    }

    private String getClientParams() {
        if (this.clientSideEnabled) {
            if (this.clientSideFailoverEnabled) {
                return this.isSsl() ? "?nested.socket.verifyHostName=false" : "";
            }
            return this.isSsl() ? "?socket.verifyHostName=false" : "";
        }
        if (this.clientSideFailoverEnabled) {
            return this.isSsl() ? "?nested.socket.verifyHostName=false&nested.wireFormat.maxFrameSizeEnabled=false" : "?nested.wireFormat.maxFrameSizeEnabled=false";
        }
        return this.isSsl() ? "?socket.verifyHostName=false&wireFormat.maxFrameSizeEnabled=false" : "?wireFormat.maxFrameSizeEnabled=false";
    }

    private String getClientUri(int port) {
        if (this.isFailover()) {
            return "failover:(" + (this.isSsl() ? "ssl" : "tcp") + "://localhost:" + port + ")" + this.getClientParams() + "&maxReconnectAttempts=1&startupMaxReconnectAttempts=1";
        }
        return (this.isSsl() ? "ssl" : "tcp") + "://localhost:" + port + this.getClientParams();
    }
}

