/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb;

import jakarta.jms.Connection;
import jakarta.jms.JMSException;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.store.kahadb.AbstractMultiKahaDBDeletionTest;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class MultiKahaDBTopicDeletionTest
extends AbstractMultiKahaDBDeletionTest {
    protected static final Logger LOG = LoggerFactory.getLogger(MultiKahaDBTopicDeletionTest.class);
    protected static ActiveMQTopic TOPIC1 = new ActiveMQTopic("test.>");
    protected static ActiveMQTopic TOPIC2 = new ActiveMQTopic("test.t.topic");

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({TOPIC1, TOPIC2}, {TOPIC2, TOPIC1});
    }

    public MultiKahaDBTopicDeletionTest(ActiveMQTopic dest1, ActiveMQTopic dest2) {
        super((ActiveMQDestination)dest1, (ActiveMQDestination)dest2);
    }

    @Override
    protected void createConsumer(ActiveMQDestination dest) throws JMSException {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.brokerConnectURI);
        Connection connection = factory.createConnection();
        connection.setClientID("client1");
        connection.start();
        Session session = connection.createSession(false, 1);
        session.createDurableSubscriber((Topic)dest, "sub1");
    }

    @Override
    protected WildcardFileFilter getStoreFileFilter() {
        return new WildcardFileFilter("topic*");
    }
}

