/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Session;
import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.store.kahadb.AbstractMultiKahaDBDeletionTest;
import org.apache.activemq.store.kahadb.MultiKahaDBTopicDeletionTest;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class MultiKahaDBQueueDeletionTest
extends AbstractMultiKahaDBDeletionTest {
    protected static final Logger LOG = LoggerFactory.getLogger(MultiKahaDBTopicDeletionTest.class);
    protected static ActiveMQQueue QUEUE1 = new ActiveMQQueue("test.>");
    protected static ActiveMQQueue QUEUE2 = new ActiveMQQueue("test.t.queue");

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({QUEUE1, QUEUE2}, {QUEUE2, QUEUE1});
    }

    public MultiKahaDBQueueDeletionTest(ActiveMQQueue dest1, ActiveMQQueue dest2) {
        super((ActiveMQDestination)dest1, (ActiveMQDestination)dest2);
    }

    @Override
    protected void createConsumer(ActiveMQDestination dest) throws JMSException {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.brokerConnectURI);
        Connection connection = factory.createConnection();
        connection.setClientID("client1");
        connection.start();
        Session session = connection.createSession(false, 1);
        session.createConsumer((Destination)dest);
    }

    @Override
    protected WildcardFileFilter getStoreFileFilter() {
        return new WildcardFileFilter("queue*");
    }
}

