/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.PersistenceAdapterTestSupport;
import org.apache.activemq.store.kahadb.KahaDBStore;
import org.apache.activemq.store.kahadb.MessageDatabase;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.layout.MessageLayout;

public class KahaDBPersistenceAdapterTest
extends PersistenceAdapterTestSupport {
    protected PersistenceAdapter createPersistenceAdapter(boolean delete) throws IOException {
        KahaDBStore kaha = new KahaDBStore();
        kaha.setDirectory(new File("target/activemq-data/kahadb"));
        if (delete) {
            kaha.deleteAllMessages();
        }
        return kaha;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoReplayOnStop() throws Exception {
        this.brokerService.getPersistenceAdapter().checkpoint(true);
        this.brokerService.stop();
        final AtomicBoolean gotSomeReplay = new AtomicBoolean(Boolean.FALSE);
        final AtomicBoolean trappedLogMessages = new AtomicBoolean(Boolean.FALSE);
        AbstractAppender appender = new AbstractAppender("testAppender", (Filter)new AbstractFilter(){}, (Layout)new MessageLayout(), false, new Property[0]){

            public void append(LogEvent event) {
                trappedLogMessages.set(true);
                if (event.getLevel().equals((Object)Level.INFO) && event.getMessage() != null && event.getMessage().getFormattedMessage().contains("Recovery replayed ")) {
                    gotSomeReplay.set(true);
                }
            }
        };
        appender.start();
        try {
            Configurator.setLevel((String)MessageDatabase.class.getName(), (Level)Level.DEBUG);
            ((Logger)LogManager.getLogger(MessageDatabase.class)).addAppender((Appender)appender);
            this.brokerService = new BrokerService();
            this.pa = this.createPersistenceAdapter(false);
            this.brokerService.setPersistenceAdapter(this.pa);
            this.brokerService.start();
        }
        finally {
            appender.stop();
            ((Logger)LogManager.getRootLogger()).removeAppender((Appender)appender);
            ((Logger)LogManager.getLogger(MessageDatabase.class)).removeAppender((Appender)appender);
        }
        KahaDBPersistenceAdapterTest.assertTrue((String)"log capture working", (boolean)trappedLogMessages.get());
        KahaDBPersistenceAdapterTest.assertFalse((String)"no replay message in the log", (boolean)gotSomeReplay.get());
    }
}

