/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.store.AbstractMessageStoreSizeStatTest;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.commons.io.FileUtils;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class KahaDBMessageStoreSizeStatTest
extends AbstractMessageStoreSizeStatTest {
    protected static final Logger LOG = LoggerFactory.getLogger(KahaDBMessageStoreSizeStatTest.class);
    @Rule
    public TemporaryFolder dataFileDir = new TemporaryFolder(new File("target"));

    @Parameterized.Parameters(name="subStatsEnabled={0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({true}, {false});
    }

    public KahaDBMessageStoreSizeStatTest(boolean subStatsEnabled) {
        super(subStatsEnabled);
    }

    @Override
    protected void setUpBroker(boolean clearDataDir) throws Exception {
        if (clearDataDir && this.dataFileDir.getRoot().exists()) {
            FileUtils.cleanDirectory((File)this.dataFileDir.getRoot());
        }
        super.setUpBroker(clearDataDir);
    }

    @Override
    protected void initPersistence(BrokerService brokerService) throws IOException {
        this.broker.setPersistent(true);
        this.broker.setDataDirectoryFile(this.dataFileDir.getRoot());
        KahaDBPersistenceAdapter adapter = (KahaDBPersistenceAdapter)this.broker.getPersistenceAdapter();
        adapter.setEnableSubscriptionStatistics(this.subStatsEnabled);
    }

    @Test(timeout=60000L)
    public void testMessageSizeAfterRestartAndPublish() throws Exception {
        AtomicLong publishedMessageSize = new AtomicLong();
        Destination dest = this.publishTestQueueMessages(200, publishedMessageSize);
        this.verifyStats(dest, 200, publishedMessageSize.get());
        this.stopBroker();
        this.setUpBroker(false);
        dest = this.publishTestQueueMessages(200, publishedMessageSize);
        this.verifyStats(dest, 400, publishedMessageSize.get());
    }
}

