/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.statistics;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MessageConsumer;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.statistics.AbstractInflightMessageSizeTest;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class QueueSubscriptionInflightMessageSizeTest
extends AbstractInflightMessageSizeTest {
    public QueueSubscriptionInflightMessageSizeTest(int ackType, boolean optimizeAcknowledge, boolean useTopicSubscriptionInflightStats) {
        super(ackType, optimizeAcknowledge, useTopicSubscriptionInflightStats);
    }

    @Override
    protected MessageConsumer getMessageConsumer(String destName) throws JMSException {
        return this.session.createConsumer(this.getDestination(destName));
    }

    @Override
    protected Subscription getSubscription() {
        return (Subscription)this.amqDestination.getConsumers().get(0);
    }

    @Override
    protected Destination getDestination(String destName) throws JMSException {
        return this.session.createQueue(destName);
    }

    @Override
    protected ActiveMQDestination getActiveMQDestination(String destName) {
        return new ActiveMQQueue(destName);
    }
}

