/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.spring;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

public class SpringProducer {
    private static final Logger LOG = LoggerFactory.getLogger(SpringProducer.class);
    private JmsTemplate template;
    private Destination destination;
    private int messageCount = 10;

    public void start() throws JMSException {
        for (int i = 0; i < this.messageCount; ++i) {
            final String text = "Text for message: " + i;
            this.template.send(this.destination, new MessageCreator(){

                public Message createMessage(Session session) throws JMSException {
                    LOG.info("Sending message: " + text);
                    TextMessage message = session.createTextMessage(text);
                    message.setStringProperty("next", "foo");
                    return message;
                }
            });
        }
    }

    public void stop() throws JMSException {
    }

    public JmsTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(JmsTemplate template) {
        this.template = template;
    }

    public int getMessageCount() {
        return this.messageCount;
    }

    public void setMessageCount(int messageCount) {
        this.messageCount = messageCount;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }
}

