/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.spring;

import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.activemq.spring.ActiveMQConnectionFactory;
import org.apache.activemq.spring.ActiveMQConnectionFactoryFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQConnectionFactoryFactoryBeanTest
extends TestCase {
    private static final transient Logger LOG = LoggerFactory.getLogger(ActiveMQConnectionFactoryFactoryBeanTest.class);
    private ActiveMQConnectionFactoryFactoryBean factory;

    public void testSingleTcpURL() throws Exception {
        this.factory.setTcpHostAndPort("tcp://localhost:61616");
        this.assertCreatedURL("failover:(tcp://localhost:61616)");
    }

    public void testSingleTcpURLWithInactivityTimeout() throws Exception {
        this.factory.setTcpHostAndPort("tcp://localhost:61616");
        this.factory.setMaxInactivityDuration(Long.valueOf(60000L));
        this.assertCreatedURL("failover:(tcp://localhost:61616?wireFormat.maxInactivityDuration=60000)");
    }

    public void testSingleTcpURLWithInactivityTimeoutAndTcpNoDelay() throws Exception {
        this.factory.setTcpHostAndPort("tcp://localhost:61616");
        this.factory.setMaxInactivityDuration(Long.valueOf(50000L));
        this.factory.setTcpProperties("tcpNoDelayEnabled=true");
        this.assertCreatedURL("failover:(tcp://localhost:61616?wireFormat.maxInactivityDuration=50000&tcpNoDelayEnabled=true)");
    }

    public void testSingleTcpURLWithInactivityTimeoutAndMaxReconnectDelay() throws Exception {
        this.factory.setTcpHostAndPort("tcp://localhost:61616");
        this.factory.setMaxInactivityDuration(Long.valueOf(60000L));
        this.factory.setMaxReconnectDelay(Long.valueOf(50000L));
        this.assertCreatedURL("failover:(tcp://localhost:61616?wireFormat.maxInactivityDuration=60000)?maxReconnectDelay=50000");
    }

    public void testSingleTcpURLWithInactivityTimeoutAndMaxReconnectDelayAndFailoverProperty() throws Exception {
        this.factory.setTcpHostAndPort("tcp://localhost:61616");
        this.factory.setMaxInactivityDuration(Long.valueOf(40000L));
        this.factory.setMaxReconnectDelay(Long.valueOf(30000L));
        this.factory.setFailoverProperties("useExponentialBackOff=false");
        this.assertCreatedURL("failover:(tcp://localhost:61616?wireFormat.maxInactivityDuration=40000)?maxReconnectDelay=30000&useExponentialBackOff=false");
    }

    public void testMultipleTcpURLsWithInactivityTimeoutAndMaxReconnectDelayAndFailoverProperty() throws Exception {
        this.factory.setTcpHostAndPorts(Arrays.asList("tcp://localhost:61618", "tcp://foo:61619"));
        this.factory.setMaxInactivityDuration(Long.valueOf(40000L));
        this.factory.setMaxReconnectDelay(Long.valueOf(30000L));
        this.factory.setFailoverProperties("useExponentialBackOff=false");
        this.assertCreatedURL("failover:(tcp://localhost:61618?wireFormat.maxInactivityDuration=40000,tcp://foo:61619?wireFormat.maxInactivityDuration=40000)?maxReconnectDelay=30000&useExponentialBackOff=false");
    }

    protected void assertCreatedURL(String expectedURL) throws Exception {
        String url = this.factory.getBrokerURL();
        LOG.debug("Generated URL: " + url);
        ActiveMQConnectionFactoryFactoryBeanTest.assertEquals((String)"URL", (String)expectedURL, (String)url);
        Object value = this.factory.getObject();
        ActiveMQConnectionFactoryFactoryBeanTest.assertTrue((String)"Value should be an ActiveMQConnectionFactory", (boolean)(value instanceof ActiveMQConnectionFactory));
        ActiveMQConnectionFactory connectionFactory = (ActiveMQConnectionFactory)value;
        String brokerURL = connectionFactory.getBrokerURL();
        ActiveMQConnectionFactoryFactoryBeanTest.assertEquals((String)"brokerURL", (String)expectedURL, (String)brokerURL);
    }

    protected void setUp() throws Exception {
        this.factory = new ActiveMQConnectionFactoryFactoryBean();
    }
}

