/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.proxy;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerTestSupport;
import org.apache.activemq.broker.StubConnection;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.proxy.ProxyConnector;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.usage.SystemUsage;

public class ProxyTestSupport
extends BrokerTestSupport {
    protected ArrayList<StubConnection> connections = new ArrayList();
    protected TransportConnector connector;
    protected PersistenceAdapter remotePersistenceAdapter;
    protected BrokerService remoteBroker;
    protected SystemUsage remoteMemoryManager;
    protected TransportConnector remoteConnector;
    private ProxyConnector proxyConnector;
    private ProxyConnector remoteProxyConnector;

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService service = new BrokerService();
        service.setBrokerName("broker1");
        service.setPersistent(false);
        service.setUseJmx(false);
        this.connector = service.addConnector(this.getLocalURI());
        this.proxyConnector = new ProxyConnector();
        this.proxyConnector.setName("proxy");
        this.proxyConnector.setBind(new URI(this.getLocalProxyURI()));
        this.proxyConnector.setRemote(new URI("fanout:static://" + this.getRemoteURI()));
        service.addProxyConnector(this.proxyConnector);
        return service;
    }

    protected BrokerService createRemoteBroker() throws Exception {
        BrokerService service = new BrokerService();
        service.setBrokerName("broker2");
        service.setPersistent(false);
        service.setUseJmx(false);
        this.remoteConnector = service.addConnector(this.getRemoteURI());
        this.remoteProxyConnector = new ProxyConnector();
        this.remoteProxyConnector.setName("remoteProxy");
        this.remoteProxyConnector.setBind(new URI(this.getRemoteProxyURI()));
        this.remoteProxyConnector.setRemote(new URI("fanout:static://" + this.getLocalURI()));
        service.addProxyConnector(this.remoteProxyConnector);
        return service;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.remoteBroker = this.createRemoteBroker();
        this.remoteBroker.start();
    }

    @Override
    protected void tearDown() throws Exception {
        Iterator<StubConnection> iter = this.connections.iterator();
        while (iter.hasNext()) {
            StubConnection connection = iter.next();
            try {
                connection.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            iter.remove();
        }
        this.remoteBroker.stop();
        super.tearDown();
    }

    protected String getRemoteURI() {
        return "tcp://localhost:6171";
    }

    protected String getLocalURI() {
        return "tcp://localhost:6161";
    }

    protected String getRemoteProxyURI() {
        return "tcp://localhost:6162";
    }

    protected String getLocalProxyURI() {
        return "tcp://localhost:6172";
    }

    @Override
    protected StubConnection createConnection() throws Exception {
        Transport transport = TransportFactory.connect((URI)this.connector.getServer().getConnectURI());
        StubConnection connection = new StubConnection(transport);
        this.connections.add(connection);
        return connection;
    }

    protected StubConnection createRemoteConnection() throws Exception {
        Transport transport = TransportFactory.connect((URI)this.remoteConnector.getServer().getConnectURI());
        StubConnection connection = new StubConnection(transport);
        this.connections.add(connection);
        return connection;
    }

    protected StubConnection createProxyConnection() throws Exception {
        Transport transport = TransportFactory.connect((URI)this.proxyConnector.getServer().getConnectURI());
        StubConnection connection = new StubConnection(transport);
        this.connections.add(connection);
        return connection;
    }

    protected StubConnection createRemoteProxyConnection() throws Exception {
        Transport transport = TransportFactory.connect((URI)this.remoteProxyConnector.getServer().getConnectURI());
        StubConnection connection = new StubConnection(transport);
        this.connections.add(connection);
        return connection;
    }
}

