/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.perf;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Session;
import org.apache.activemq.perf.PerfConsumer;
import org.apache.activemq.perf.SimpleTopicTest;

public class SimpleQueueTest
extends SimpleTopicTest {
    protected long initialConsumerDelay = 0L;
    protected long consumerSleep = 0L;

    @Override
    protected Destination createDestination(Session s, String destinationName) throws JMSException {
        return s.createQueue(destinationName);
    }

    @Override
    protected void setUp() throws Exception {
        this.numberOfConsumers = 1;
        super.setUp();
    }

    @Override
    protected PerfConsumer createConsumer(ConnectionFactory fac, Destination dest, int number) throws JMSException {
        PerfConsumer consumer = new PerfConsumer(fac, dest);
        consumer.setInitialDelay(this.initialConsumerDelay);
        consumer.setSleepDuration(this.consumerSleep);
        boolean enableAudit = this.numberOfConsumers <= 1;
        System.err.println("Enable Audit = " + enableAudit);
        consumer.setEnableAudit(enableAudit);
        return consumer;
    }
}

