/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire;

import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collection;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.SslContext;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.spring.SpringSslContext;
import org.apache.activemq.transport.tcp.TcpTransportServer;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class OpenWireConnectionTimeoutTest {
    private static final Logger LOG = LoggerFactory.getLogger(OpenWireConnectionTimeoutTest.class);
    @Rule
    public TestName name = new TestName();
    public static final String KEYSTORE_TYPE = "jks";
    public static final String PASSWORD = "password";
    public static final String SERVER_KEYSTORE = "src/test/resources/server.keystore";
    public static final String TRUST_KEYSTORE = "src/test/resources/client.keystore";
    private Socket connection;
    protected String connectorScheme;
    protected int port;
    protected BrokerService brokerService;
    protected Vector<Throwable> exceptions = new Vector();

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"tcp"}, {"ssl"}, {"nio"}, {"nio+ssl"}, {"auto"}, {"auto+ssl"}, {"auto+nio"}, {"auto+nio+ssl"});
    }

    public OpenWireConnectionTimeoutTest(String connectorScheme) {
        this.connectorScheme = connectorScheme;
    }

    protected String getConnectorScheme() {
        return this.connectorScheme;
    }

    public String getTestName() {
        return this.name.getMethodName();
    }

    @Before
    public void setUp() throws Exception {
        LOG.info("========== start " + this.getTestName() + " ==========");
        this.startBroker();
    }

    @After
    public void tearDown() throws Exception {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.connection = null;
        }
        this.stopBroker();
        LOG.info("========== start " + this.getTestName() + " ==========");
    }

    public String getAdditionalConfig() {
        return "?transport.connectAttemptTimeout=1200&protocolDetectionTimeOut=1200";
    }

    @Test(timeout=90000L)
    public void testInactivityMonitor() throws Exception {
        Thread t1 = new Thread(){

            @Override
            public void run() {
                try {
                    OpenWireConnectionTimeoutTest.this.connection = OpenWireConnectionTimeoutTest.this.createConnection();
                    OpenWireConnectionTimeoutTest.this.connection.getOutputStream().write(65);
                    OpenWireConnectionTimeoutTest.this.connection.getOutputStream().flush();
                }
                catch (Exception ex) {
                    LOG.error("unexpected exception on connect/disconnect", (Throwable)ex);
                    OpenWireConnectionTimeoutTest.this.exceptions.add(ex);
                }
            }
        };
        t1.start();
        Assert.assertTrue((String)"one connection", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                TcpTransportServer server = (TcpTransportServer)OpenWireConnectionTimeoutTest.this.brokerService.getTransportConnectorByScheme(OpenWireConnectionTimeoutTest.this.getConnectorScheme()).getServer();
                return 1 == server.getCurrentTransportCount().get();
            }
        }, (long)TimeUnit.SECONDS.toMillis(15L), (long)TimeUnit.MILLISECONDS.toMillis(250L)));
        Assert.assertTrue((String)"no dangling connections", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                TcpTransportServer server = (TcpTransportServer)OpenWireConnectionTimeoutTest.this.brokerService.getTransportConnectorByScheme(OpenWireConnectionTimeoutTest.this.getConnectorScheme()).getServer();
                return 0 == server.getCurrentTransportCount().get();
            }
        }, (long)TimeUnit.SECONDS.toMillis(15L), (long)TimeUnit.MILLISECONDS.toMillis(500L)));
        Assert.assertTrue((String)"no exceptions", (boolean)this.exceptions.isEmpty());
    }

    protected Socket createConnection() throws IOException {
        boolean useSsl = false;
        switch (this.connectorScheme) {
            case "tcp": 
            case "auto": 
            case "nio": 
            case "auto+nio": {
                break;
            }
            case "ssl": 
            case "auto+ssl": 
            case "nio+ssl": 
            case "auto+nio+ssl": {
                useSsl = true;
                break;
            }
            default: {
                throw new IOException("Invalid OpenWire connector scheme passed to test.");
            }
        }
        if (useSsl) {
            return SSLSocketFactory.getDefault().createSocket("localhost", this.port);
        }
        return new Socket("localhost", this.port);
    }

    protected void startBroker() throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setPersistent(false);
        this.brokerService.setSchedulerSupport(false);
        this.brokerService.setAdvisorySupport(false);
        this.brokerService.setUseJmx(false);
        this.brokerService.getManagementContext().setCreateConnector(false);
        File classesDir = new File(OpenWireConnectionTimeoutTest.class.getProtectionDomain().getCodeSource().getLocation().getFile());
        File keystore = new File(classesDir, "../../src/test/resources/server.keystore");
        SpringSslContext sslContext = new SpringSslContext();
        sslContext.setKeyStore(keystore.getCanonicalPath());
        sslContext.setKeyStorePassword(PASSWORD);
        sslContext.setTrustStore(keystore.getCanonicalPath());
        sslContext.setTrustStorePassword(PASSWORD);
        sslContext.afterPropertiesSet();
        this.brokerService.setSslContext((SslContext)sslContext);
        System.setProperty("javax.net.ssl.trustStore", keystore.getCanonicalPath());
        System.setProperty("javax.net.ssl.trustStorePassword", PASSWORD);
        System.setProperty("javax.net.ssl.trustStoreType", KEYSTORE_TYPE);
        System.setProperty("javax.net.ssl.keyStore", keystore.getCanonicalPath());
        System.setProperty("javax.net.ssl.keyStorePassword", PASSWORD);
        System.setProperty("javax.net.ssl.keyStoreType", KEYSTORE_TYPE);
        TransportConnector connector = null;
        switch (this.connectorScheme) {
            case "tcp": {
                connector = this.brokerService.addConnector("tcp://0.0.0.0:0" + this.getAdditionalConfig());
                break;
            }
            case "nio": {
                connector = this.brokerService.addConnector("nio://0.0.0.0:0" + this.getAdditionalConfig());
                break;
            }
            case "ssl": {
                connector = this.brokerService.addConnector("ssl://0.0.0.0:0" + this.getAdditionalConfig());
                break;
            }
            case "nio+ssl": {
                connector = this.brokerService.addConnector("nio+ssl://0.0.0.0:0" + this.getAdditionalConfig());
                break;
            }
            case "auto": {
                connector = this.brokerService.addConnector("auto://0.0.0.0:0" + this.getAdditionalConfig());
                break;
            }
            case "auto+nio": {
                connector = this.brokerService.addConnector("auto+nio://0.0.0.0:0" + this.getAdditionalConfig());
                break;
            }
            case "auto+ssl": {
                connector = this.brokerService.addConnector("auto+ssl://0.0.0.0:0" + this.getAdditionalConfig());
                break;
            }
            case "auto+nio+ssl": {
                connector = this.brokerService.addConnector("auto+nio+ssl://0.0.0.0:0" + this.getAdditionalConfig());
                break;
            }
            default: {
                throw new IOException("Invalid OpenWire connector scheme passed to test.");
            }
        }
        this.brokerService.start();
        this.brokerService.waitUntilStarted();
        this.port = connector.getPublishableConnectURI().getPort();
    }

    public void stopBroker() throws Exception {
        if (this.brokerService != null) {
            this.brokerService.stop();
            this.brokerService.waitUntilStopped();
            this.brokerService = null;
        }
    }

    static {
        System.setProperty("javax.net.ssl.trustStore", TRUST_KEYSTORE);
        System.setProperty("javax.net.ssl.trustStorePassword", PASSWORD);
        System.setProperty("javax.net.ssl.trustStoreType", KEYSTORE_TYPE);
        System.setProperty("javax.net.ssl.keyStore", SERVER_KEYSTORE);
        System.setProperty("javax.net.ssl.keyStoreType", KEYSTORE_TYPE);
        System.setProperty("javax.net.ssl.keyStorePassword", PASSWORD);
    }
}

