/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network.jms;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicRequestor;
import jakarta.jms.TopicSession;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class TopicBridgeSpringTest
extends TestCase
implements MessageListener {
    protected static final int MESSAGE_COUNT = 10;
    private static final Logger LOG = LoggerFactory.getLogger(TopicBridgeSpringTest.class);
    protected AbstractApplicationContext context;
    protected TopicConnection localConnection;
    protected TopicConnection remoteConnection;
    protected TopicRequestor requestor;
    protected TopicSession requestServerSession;
    protected MessageConsumer requestServerConsumer;
    protected MessageProducer requestServerProducer;

    protected void setUp() throws Exception {
        super.setUp();
        this.context = this.createApplicationContext();
        ActiveMQConnectionFactory fac = (ActiveMQConnectionFactory)this.context.getBean("localFactory");
        this.localConnection = fac.createTopicConnection();
        this.localConnection.start();
        this.requestServerSession = this.localConnection.createTopicSession(false, 1);
        Topic theTopic = this.requestServerSession.createTopic(((Object)((Object)this)).getClass().getName());
        this.requestServerConsumer = this.requestServerSession.createConsumer((Destination)theTopic);
        this.requestServerConsumer.setMessageListener((MessageListener)this);
        this.requestServerProducer = this.requestServerSession.createProducer(null);
        fac = (ActiveMQConnectionFactory)this.context.getBean("remoteFactory");
        this.remoteConnection = fac.createTopicConnection();
        this.remoteConnection.start();
        TopicSession session = this.remoteConnection.createTopicSession(false, 1);
        this.requestor = new TopicRequestor(session, theTopic);
    }

    protected AbstractApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/activemq/network/jms/topic-spring.xml");
    }

    protected void tearDown() throws Exception {
        this.localConnection.close();
        super.tearDown();
    }

    public void testTopicRequestorOverBridge() throws JMSException {
        for (int i = 0; i < 10; ++i) {
            TextMessage msg = this.requestServerSession.createTextMessage("test msg: " + i);
            LOG.info("Making request: " + msg);
            TextMessage result = (TextMessage)this.requestor.request((Message)msg);
            TopicBridgeSpringTest.assertNotNull((Object)result);
            LOG.info("Received result: " + result.getText());
        }
    }

    public void onMessage(Message msg) {
        try {
            TextMessage textMsg = (TextMessage)msg;
            String payload = "REPLY: " + textMsg.getText();
            Destination replyTo = msg.getJMSReplyTo();
            textMsg.clearBody();
            textMsg.setText(payload);
            LOG.info("Sending response: " + textMsg);
            this.requestServerProducer.send(replyTo, (Message)textMsg);
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }
}

