/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.network.NetworkReconnectTest;

public class SSHTunnelNetworkReconnectTest
extends NetworkReconnectTest {
    ArrayList<Process> processes = new ArrayList();

    @Override
    protected BrokerService createFirstBroker() throws Exception {
        return BrokerFactory.createBroker((URI)new URI("xbean:org/apache/activemq/network/ssh-reconnect-broker1.xml"));
    }

    @Override
    protected BrokerService createSecondBroker() throws Exception {
        return BrokerFactory.createBroker((URI)new URI("xbean:org/apache/activemq/network/ssh-reconnect-broker2.xml"));
    }

    @Override
    protected void setUp() throws Exception {
        this.startProcess("ssh -Nn -L60006:localhost:61616 localhost");
        this.startProcess("ssh -Nn -L60007:localhost:61617 localhost");
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        for (Process p : this.processes) {
            p.destroy();
        }
    }

    private void startProcess(String command) throws IOException {
        final Process process = Runtime.getRuntime().exec(command);
        this.processes.add(process);
        new Thread("stdout: " + command){

            @Override
            public void run() {
                try {
                    int c;
                    InputStream is = process.getInputStream();
                    while ((c = is.read()) >= 0) {
                        System.out.write(c);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }.start();
        new Thread("stderr: " + command){

            @Override
            public void run() {
                try {
                    int c;
                    InputStream is = process.getErrorStream();
                    while ((c = is.read()) >= 0) {
                        System.err.write(c);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }.start();
    }
}

