/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.util.Arrays;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.broker.StubConnection;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.network.DemandForwardingBridge;
import org.apache.activemq.network.NetworkBridgeConfiguration;
import org.apache.activemq.network.NetworkTestSupport;

public class DemandForwardingBridgeFilterTest
extends NetworkTestSupport {
    private DemandForwardingBridge bridge;
    private StubConnection producerConnection;
    private ProducerInfo producerInfo;
    private StubConnection consumerConnection;
    private SessionInfo consumerSessionInfo;

    public void testWildcardOnExcludedDestination() throws Exception {
        NetworkBridgeConfiguration configuration = this.getDefaultBridgeConfiguration();
        configuration.setExcludedDestinations(Arrays.asList(ActiveMQDestination.createDestination((String)"OTHER.>", (byte)2)));
        configuration.setDynamicallyIncludedDestinations(Arrays.asList(ActiveMQDestination.createDestination((String)"TEST", (byte)1)));
        this.configureAndStartBridge(configuration);
        this.assertReceiveMessageOn("TEST", (byte)1);
        this.assertReceiveNoMessageOn("OTHER.T1", (byte)2);
    }

    public void testWildcardOnTwoExcludedDestination() throws Exception {
        NetworkBridgeConfiguration configuration = this.getDefaultBridgeConfiguration();
        configuration.setExcludedDestinations(Arrays.asList(ActiveMQDestination.createDestination((String)"OTHER.>", (byte)1), ActiveMQDestination.createDestination((String)"TEST.X1", (byte)1)));
        configuration.setDynamicallyIncludedDestinations(Arrays.asList(ActiveMQDestination.createDestination((String)"TEST.X2", (byte)1)));
        this.configureAndStartBridge(configuration);
        this.assertReceiveMessageOn("TEST.X2", (byte)1);
        this.assertReceiveNoMessageOn("OTHER.X1", (byte)1);
        this.assertReceiveNoMessageOn("TEST.X1", (byte)1);
    }

    public void testWildcardOnDynamicallyIncludedDestination() throws Exception {
        NetworkBridgeConfiguration configuration = this.getDefaultBridgeConfiguration();
        configuration.setDynamicallyIncludedDestinations(Arrays.asList(ActiveMQDestination.createDestination((String)"OTHER.>", (byte)1), ActiveMQDestination.createDestination((String)"TEST.X2", (byte)1)));
        this.configureAndStartBridge(configuration);
        this.assertReceiveMessageOn("OTHER.X1", (byte)1);
        this.assertReceiveMessageOn("TEST.X2", (byte)1);
    }

    public void testDistinctTopicAndQueue() throws Exception {
        NetworkBridgeConfiguration configuration = this.getDefaultBridgeConfiguration();
        configuration.setExcludedDestinations(Arrays.asList(ActiveMQDestination.createDestination((String)">", (byte)2)));
        configuration.setDynamicallyIncludedDestinations(Arrays.asList(ActiveMQDestination.createDestination((String)">", (byte)1)));
        this.configureAndStartBridge(configuration);
        this.assertReceiveMessageOn("TEST", (byte)1);
        this.assertReceiveNoMessageOn("TEST", (byte)2);
    }

    public void testListOfExcludedDestinationWithWildcard() throws Exception {
        NetworkBridgeConfiguration configuration = this.getDefaultBridgeConfiguration();
        configuration.setExcludedDestinations(Arrays.asList(ActiveMQDestination.createDestination((String)"OTHER.>", (byte)2), ActiveMQDestination.createDestination((String)"TEST.*", (byte)2)));
        configuration.setDynamicallyIncludedDestinations(Arrays.asList(ActiveMQDestination.createDestination((String)"TEST.X1", (byte)1)));
        this.configureAndStartBridge(configuration);
        this.assertReceiveMessageOn("TEST.X1", (byte)1);
        this.assertReceiveNoMessageOn("OTHER.T1", (byte)2);
        this.assertReceiveNoMessageOn("OTHER.T2", (byte)2);
    }

    public void testExcludeStaticDestinations() throws Exception {
        NetworkBridgeConfiguration configuration = this.getDefaultBridgeConfiguration();
        configuration.setExcludedDestinations(Arrays.asList(ActiveMQDestination.createDestination((String)"TEST.X1", (byte)1), ActiveMQDestination.createDestination((String)"OTHER.X1", (byte)1)));
        configuration.setStaticallyIncludedDestinations(Arrays.asList(ActiveMQDestination.createDestination((String)"TEST.>", (byte)1), ActiveMQDestination.createDestination((String)"OTHER.X1", (byte)1), ActiveMQDestination.createDestination((String)"OTHER.X2", (byte)1)));
        this.configureAndStartBridge(configuration);
        this.assertReceiveNoMessageOn("TEST.X1", (byte)1);
        this.assertReceiveMessageOn("TEST.X2", (byte)1);
        this.assertReceiveNoMessageOn("OTHER.X1", (byte)1);
        this.assertReceiveMessageOn("OTHER.X2", (byte)1);
    }

    private void assertReceiveMessageOn(String destinationName, byte destinationType) throws Exception, InterruptedException {
        ActiveMQDestination destination = ActiveMQDestination.createDestination((String)destinationName, (byte)destinationType);
        this.producerConnection.send((Command)this.createMessage(this.producerInfo, destination, destinationType));
        Message m = this.createConsumerAndReceiveMessage(destination);
        DemandForwardingBridgeFilterTest.assertNotNull((Object)m);
    }

    private void assertReceiveNoMessageOn(String destinationName, byte destinationType) throws Exception, InterruptedException {
        ActiveMQDestination destination = ActiveMQDestination.createDestination((String)destinationName, (byte)destinationType);
        this.producerConnection.send((Command)this.createMessage(this.producerInfo, destination, destinationType));
        Message m = this.createConsumerAndReceiveMessage(destination);
        DemandForwardingBridgeFilterTest.assertNull((Object)m);
    }

    private Message createConsumerAndReceiveMessage(ActiveMQDestination destination) throws Exception {
        ConsumerInfo consumerInfo = this.createConsumerInfo(this.consumerSessionInfo, destination);
        this.consumerConnection.send((Command)consumerInfo);
        Message m = this.receiveMessage(this.consumerConnection);
        return m;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.producerConnection = this.createConnection();
        ConnectionInfo producerConnectionInfo = this.createConnectionInfo();
        SessionInfo producerSessionInfo = this.createSessionInfo(producerConnectionInfo);
        this.producerInfo = this.createProducerInfo(producerSessionInfo);
        this.producerConnection.send((Command)producerConnectionInfo);
        this.producerConnection.send((Command)producerSessionInfo);
        this.producerConnection.send((Command)this.producerInfo);
        this.consumerConnection = this.createRemoteConnection();
        ConnectionInfo consumerConnectionInfo = this.createConnectionInfo();
        this.consumerSessionInfo = this.createSessionInfo(consumerConnectionInfo);
        this.consumerConnection.send((Command)consumerConnectionInfo);
        this.consumerConnection.send((Command)this.consumerSessionInfo);
    }

    @Override
    protected void tearDown() throws Exception {
        this.bridge.stop();
        super.tearDown();
    }

    public static Test suite() {
        return DemandForwardingBridgeFilterTest.suite(DemandForwardingBridgeFilterTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)DemandForwardingBridgeFilterTest.suite());
    }

    public NetworkBridgeConfiguration getDefaultBridgeConfiguration() {
        NetworkBridgeConfiguration config = new NetworkBridgeConfiguration();
        config.setBrokerName("local");
        config.setDispatchAsync(false);
        return config;
    }

    private void configureAndStartBridge(NetworkBridgeConfiguration configuration) throws Exception {
        this.bridge = new DemandForwardingBridge(configuration, this.createTransport(), this.createRemoteTransport());
        this.bridge.setBrokerService(this.broker);
        this.bridge.setDynamicallyIncludedDestinations(configuration.getDynamicallyIncludedDestinations().toArray(new ActiveMQDestination[configuration.getDynamicallyIncludedDestinations().size()]));
        this.bridge.setExcludedDestinations(configuration.getExcludedDestinations().toArray(new ActiveMQDestination[configuration.getExcludedDestinations().size()]));
        this.bridge.setStaticallyIncludedDestinations(configuration.getStaticallyIncludedDestinations().toArray(new ActiveMQDestination[configuration.getStaticallyIncludedDestinations().size()]));
        this.bridge.start();
    }
}

