/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jms2;

import jakarta.jms.Destination;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.Queue;
import jakarta.jms.XAJMSContext;
import org.apache.activemq.ActiveMQXAContext;
import org.apache.activemq.jms2.ActiveMQJMS2XATestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ActiveMQJMS2XAContextTest
extends ActiveMQJMS2XATestBase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.activemqXAConnectionFactory.setXaAckMode(1);
    }

    @Test
    public void testConnectionFactoryCreateXAContext() {
        try (XAJMSContext jmsContext = this.activemqXAConnectionFactory.createXAContext();){
            Assert.assertNotNull((Object)jmsContext);
            jmsContext.start();
            Assert.assertTrue((boolean)ActiveMQXAContext.class.isAssignableFrom(jmsContext.getClass()));
            Queue destination = jmsContext.createQueue(this.methodNameDestinationName);
            ActiveMQJMS2XAContextTest.sendMessage((JMSContext)jmsContext, (Destination)destination, "Test-" + this.methodNameDestinationName);
            ActiveMQJMS2XAContextTest.recvMessage((JMSContext)jmsContext, (Destination)destination, "Test-" + this.methodNameDestinationName);
        }
        catch (JMSException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testConnectionFactoryCreateContextUserPass() {
        try (XAJMSContext jmsContext = this.activemqXAConnectionFactory.createXAContext("admin", "admin");){
            Assert.assertNotNull((Object)jmsContext);
            jmsContext.start();
            Assert.assertTrue((boolean)ActiveMQXAContext.class.isAssignableFrom(jmsContext.getClass()));
            Queue destination = jmsContext.createQueue(this.methodNameDestinationName);
            ActiveMQJMS2XAContextTest.sendMessage((JMSContext)jmsContext, (Destination)destination, "Test-" + this.methodNameDestinationName);
            ActiveMQJMS2XAContextTest.recvMessage((JMSContext)jmsContext, (Destination)destination, "Test-" + this.methodNameDestinationName);
        }
        catch (JMSException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

