/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jms2;

import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.JMSProducer;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.QueueBrowser;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.activemq.jms2.ActiveMQJMS2TestObjectMessagePayload;
import org.apache.activemq.jms2.MessageData;
import org.junit.Assert;

public class ActiveMQJMS2TestSupport {
    protected static final Set<String> PROPERTY_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("JMS2_BOOLEAN_MIN", "JMS2_BOOLEAN_MAX", "JMS2_BYTE_MIN", "JMS2_BYTE_MAX", "JMS2_DOUBLE_MIN", "JMS2_DOUBLE_MAX", "JMS2_INT_MIN", "JMS2_INT_MAX", "JMS2_FLOAT_MIN", "JMS2_FLOAT_MAX", "JMS2_LONG_MIN", "JMS2_LONG_MAX", "JMS2_SHORT_MIN", "JMS2_SHORT_MAX", "JMS2_STRING_VAL")));

    private ActiveMQJMS2TestSupport() {
    }

    protected static Destination generateDestination(JMSContext jmsContext, String destinationType, String destinationName) throws JMSException {
        TemporaryQueue destination = null;
        switch (destinationType) {
            case "queue": {
                destination = jmsContext.createQueue(destinationName);
                break;
            }
            case "topic": {
                destination = jmsContext.createTopic(destinationName);
                break;
            }
            case "temp-queue": {
                destination = jmsContext.createTemporaryQueue();
                break;
            }
            case "temp-topic": {
                destination = jmsContext.createTemporaryTopic();
                break;
            }
            default: {
                Assert.fail((String)("Unsupported destinationType:" + destinationType));
            }
        }
        Assert.assertNotNull((Object)destination);
        return destination;
    }

    protected static Message generateMessage(JMSContext jmsContext, String messageType, String payload) throws JMSException {
        Assert.assertNotNull((Object)messageType);
        TextMessage tmpMessage = null;
        switch (messageType) {
            case "bytes": {
                BytesMessage bytesMessage = jmsContext.createBytesMessage();
                bytesMessage.writeBytes(payload.getBytes(StandardCharsets.UTF_8));
                tmpMessage = bytesMessage;
                break;
            }
            case "map": {
                MapMessage mapMessage = jmsContext.createMapMessage();
                mapMessage.setString("payload", payload);
                tmpMessage = mapMessage;
                break;
            }
            case "object": {
                tmpMessage = jmsContext.createObjectMessage((Serializable)new ActiveMQJMS2TestObjectMessagePayload(payload));
                break;
            }
            case "stream": {
                StreamMessage streamMessage = jmsContext.createStreamMessage();
                streamMessage.writeString(payload);
                tmpMessage = streamMessage;
                break;
            }
            case "text": {
                tmpMessage = jmsContext.createTextMessage(payload);
                break;
            }
            default: {
                Assert.fail((String)("Unsupported messageType:" + messageType));
            }
        }
        return tmpMessage;
    }

    protected static void populateJMSHeaders(Message message, String correlationID, Destination replyTo, String jmsType) throws JMSException {
        Assert.assertNotNull((Object)message);
        message.setJMSCorrelationID(null);
        message.setJMSReplyTo(null);
        message.setJMSType(null);
    }

    protected static String sendMessage(JMSContext jmsContext, Destination destination, Message message) throws JMSException {
        MessageData messageData = new MessageData();
        messageData.setMessage(message);
        return ActiveMQJMS2TestSupport.sendMessage(jmsContext, destination, messageData);
    }

    protected static String sendMessage(JMSContext jmsContext, Destination destination, MessageData messageData) throws JMSException {
        Assert.assertNotNull((Object)jmsContext);
        Assert.assertNotNull((Object)messageData);
        Assert.assertNotNull((Object)messageData.getMessage());
        JMSProducer jmsProducer = jmsContext.createProducer();
        if (messageData.getDeliveryDelay() != null) {
            jmsProducer.setDeliveryDelay(messageData.getDeliveryDelay().longValue());
        }
        if (messageData.getDeliveryMode() != null) {
            jmsProducer.setDeliveryMode(messageData.getDeliveryMode().intValue());
        }
        if (messageData.getDisableMessageID() != null) {
            jmsProducer.setDisableMessageID(messageData.getDisableMessageID().booleanValue());
        }
        if (messageData.getDisableMessageTimestamp() != null) {
            jmsProducer.setDisableMessageTimestamp(messageData.getDisableMessageTimestamp().booleanValue());
        }
        if (messageData.getCorrelationID() != null) {
            jmsProducer.setJMSCorrelationID(messageData.getCorrelationID());
        }
        if (messageData.getReplyTo() != null) {
            jmsProducer.setJMSReplyTo(messageData.getReplyTo());
        }
        if (messageData.getJmsType() != null) {
            jmsProducer.setJMSType(messageData.getJmsType());
        }
        if (messageData.getPriority() != null) {
            jmsProducer.setPriority(messageData.getPriority().intValue());
        }
        if (messageData.getTimeToLive() != null) {
            jmsProducer.setTimeToLive(messageData.getTimeToLive().longValue());
        }
        ActiveMQJMS2TestSupport.populateJMSProperties(jmsProducer);
        ActiveMQJMS2TestSupport.validateJMSProperties(jmsProducer);
        jmsProducer.send(destination, messageData.getMessage());
        return messageData.getMessage().getJMSMessageID();
    }

    protected static void browseMessage(JMSContext jmsContext, String testDestinationName, String expectedTextBody, boolean expectFound) throws JMSException {
        Assert.assertNotNull((Object)jmsContext);
        try (QueueBrowser queueBrowser = jmsContext.createBrowser(jmsContext.createQueue(testDestinationName));){
            Enumeration messageEnumeration = queueBrowser.getEnumeration();
            Assert.assertNotNull((Object)messageEnumeration);
            boolean found = false;
            while (!found && messageEnumeration.hasMoreElements()) {
                Message message = (Message)messageEnumeration.nextElement();
                Assert.assertNotNull((Object)message);
                Assert.assertTrue((boolean)TextMessage.class.isAssignableFrom(message.getClass()));
                Assert.assertEquals((Object)expectedTextBody, (Object)((TextMessage)TextMessage.class.cast(message)).getText());
                found = true;
            }
            Assert.assertEquals((Object)expectFound, (Object)found);
        }
    }

    protected static void validateMessageData(Message message, MessageData messageData) throws JMSException {
        Assert.assertNotNull((Object)message);
        Assert.assertNotNull((Object)messageData.getMessageType());
        Assert.assertNotNull((Object)messageData.getMessagePayload());
        ActiveMQJMS2TestSupport.validateJMSHeaders(message, messageData);
        ActiveMQJMS2TestSupport.validateJMSProperties(message);
        switch (messageData.getMessageType()) {
            case "bytes": {
                Assert.assertTrue((boolean)(message instanceof BytesMessage));
                BytesMessage bytesMessage = (BytesMessage)BytesMessage.class.cast(message);
                byte[] payload = new byte[(int)bytesMessage.getBodyLength()];
                bytesMessage.readBytes(payload);
                Assert.assertEquals((Object)messageData.getMessagePayload(), (Object)new String(payload, StandardCharsets.UTF_8));
                break;
            }
            case "map": {
                Assert.assertTrue((boolean)(message instanceof MapMessage));
                MapMessage mapMessage = (MapMessage)MapMessage.class.cast(message);
                String mapPayload = mapMessage.getString("payload");
                Assert.assertEquals((Object)messageData.getMessagePayload(), (Object)mapPayload);
                break;
            }
            case "object": {
                Assert.assertTrue((boolean)(message instanceof ObjectMessage));
                ObjectMessage objectMessage = (ObjectMessage)ObjectMessage.class.cast(message);
                Serializable tmpObject = objectMessage.getObject();
                Assert.assertNotNull((Object)tmpObject);
                Assert.assertTrue((boolean)(tmpObject instanceof ActiveMQJMS2TestObjectMessagePayload));
                Assert.assertEquals((Object)messageData.getMessagePayload(), (Object)((ActiveMQJMS2TestObjectMessagePayload)ActiveMQJMS2TestObjectMessagePayload.class.cast(tmpObject)).getPayload());
                break;
            }
            case "stream": {
                Assert.assertTrue((boolean)(message instanceof StreamMessage));
                StreamMessage streamMessage = (StreamMessage)StreamMessage.class.cast(message);
                Assert.assertEquals((Object)messageData.getMessagePayload(), (Object)streamMessage.readString());
                break;
            }
            case "text": {
                Assert.assertTrue((boolean)(message instanceof TextMessage));
                Assert.assertEquals((Object)messageData.getMessagePayload(), (Object)((TextMessage)TextMessage.class.cast(message)).getText());
                break;
            }
            default: {
                Assert.fail((String)("Unsupported messageType:" + messageData.getMessageType()));
            }
        }
    }

    private static void validateJMSHeaders(Message message, MessageData messageData) throws JMSException {
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)messageData.getCorrelationID(), (Object)message.getJMSCorrelationID());
        if (messageData.getDeliveryMode() != null) {
            Assert.assertEquals((Object)messageData.getDeliveryMode(), (Object)message.getJMSDeliveryMode());
        }
        if (messageData.getDeliveryTime() != null) {
            Assert.assertEquals((Object)messageData.getDeliveryTime(), (Object)message.getJMSDeliveryTime());
        }
        if (messageData.getExpiration() != null) {
            Assert.assertEquals((Object)messageData.getExpiration(), (Object)message.getJMSExpiration());
        }
        if (messageData.getMessageID() != null) {
            Assert.assertEquals((Object)messageData.getMessageID(), (Object)message.getJMSMessageID());
        }
        if (messageData.getPriority() != null) {
            Assert.assertEquals((Object)messageData.getPriority(), (Object)message.getJMSPriority());
        }
        Assert.assertEquals((Object)messageData.getReplyTo(), (Object)message.getJMSReplyTo());
        if (messageData.getTimestamp() != null) {
            Assert.assertEquals((Object)messageData.getTimestamp(), (Object)message.getJMSTimestamp());
        }
        if (Boolean.TRUE.equals(messageData.getDisableMessageTimestamp())) {
            Assert.assertEquals((Object)0L, (Object)message.getJMSTimestamp());
        }
        Assert.assertEquals((Object)messageData.getJmsType(), (Object)message.getJMSType());
    }

    private static void populateJMSProperties(JMSProducer jmsProducer) throws JMSException {
        jmsProducer.setProperty("JMS2_BOOLEAN_MIN", false);
        jmsProducer.setProperty("JMS2_BOOLEAN_MAX", true);
        jmsProducer.setProperty("JMS2_BYTE_MIN", (byte)-128);
        jmsProducer.setProperty("JMS2_BYTE_MAX", (byte)127);
        jmsProducer.setProperty("JMS2_DOUBLE_MIN", Double.MIN_VALUE);
        jmsProducer.setProperty("JMS2_DOUBLE_MAX", Double.MAX_VALUE);
        jmsProducer.setProperty("JMS2_INT_MIN", Integer.MIN_VALUE);
        jmsProducer.setProperty("JMS2_INT_MAX", Integer.MAX_VALUE);
        jmsProducer.setProperty("JMS2_FLOAT_MIN", Float.MIN_VALUE);
        jmsProducer.setProperty("JMS2_FLOAT_MAX", Float.MAX_VALUE);
        jmsProducer.setProperty("JMS2_LONG_MIN", Long.MIN_VALUE);
        jmsProducer.setProperty("JMS2_LONG_MAX", Long.MAX_VALUE);
        jmsProducer.setProperty("JMS2_SHORT_MIN", (short)Short.MIN_VALUE);
        jmsProducer.setProperty("JMS2_SHORT_MAX", (short)Short.MAX_VALUE);
        jmsProducer.setProperty("JMS2_STRING_VAL", "Hello World");
    }

    private static void validateJMSProperties(JMSProducer jmsProducer) throws JMSException {
        Assert.assertNotNull((Object)jmsProducer);
        Assert.assertNotNull((Object)jmsProducer.getPropertyNames());
        Assert.assertEquals((Object)PROPERTY_NAMES.size(), (Object)jmsProducer.getPropertyNames().size());
        for (String propertyName : PROPERTY_NAMES) {
            Assert.assertTrue((boolean)jmsProducer.propertyExists(propertyName));
        }
        Assert.assertEquals((Object)Boolean.FALSE, (Object)jmsProducer.getBooleanProperty("JMS2_BOOLEAN_MIN"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)jmsProducer.getBooleanProperty("JMS2_BOOLEAN_MAX"));
        Assert.assertEquals((Object)-128, (Object)jmsProducer.getByteProperty("JMS2_BYTE_MIN"));
        Assert.assertEquals((Object)127, (Object)jmsProducer.getByteProperty("JMS2_BYTE_MAX"));
        Assert.assertEquals((Object)Double.MIN_VALUE, (Object)jmsProducer.getDoubleProperty("JMS2_DOUBLE_MIN"));
        Assert.assertEquals((Object)Double.MAX_VALUE, (Object)jmsProducer.getDoubleProperty("JMS2_DOUBLE_MAX"));
        Assert.assertEquals((Object)Integer.MIN_VALUE, (Object)jmsProducer.getIntProperty("JMS2_INT_MIN"));
        Assert.assertEquals((Object)Integer.MAX_VALUE, (Object)jmsProducer.getIntProperty("JMS2_INT_MAX"));
        Assert.assertEquals((Object)Float.valueOf(Float.MIN_VALUE), (Object)Float.valueOf(jmsProducer.getFloatProperty("JMS2_FLOAT_MIN")));
        Assert.assertEquals((Object)Float.valueOf(Float.MAX_VALUE), (Object)Float.valueOf(jmsProducer.getFloatProperty("JMS2_FLOAT_MAX")));
        Assert.assertEquals((Object)Long.MIN_VALUE, (Object)jmsProducer.getLongProperty("JMS2_LONG_MIN"));
        Assert.assertEquals((Object)Long.MAX_VALUE, (Object)jmsProducer.getLongProperty("JMS2_LONG_MAX"));
        Assert.assertEquals((Object)Short.MIN_VALUE, (Object)jmsProducer.getShortProperty("JMS2_SHORT_MIN"));
        Assert.assertEquals((Object)Short.MAX_VALUE, (Object)jmsProducer.getShortProperty("JMS2_SHORT_MAX"));
        Assert.assertEquals((Object)"Hello World", (Object)jmsProducer.getStringProperty("JMS2_STRING_VAL"));
    }

    private static void validateJMSProperties(Message message) throws JMSException {
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)message.getBooleanProperty("JMS2_BOOLEAN_MIN"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)message.getBooleanProperty("JMS2_BOOLEAN_MAX"));
        Assert.assertEquals((Object)-128, (Object)message.getByteProperty("JMS2_BYTE_MIN"));
        Assert.assertEquals((Object)127, (Object)message.getByteProperty("JMS2_BYTE_MAX"));
        Assert.assertEquals((Object)Double.MIN_VALUE, (Object)message.getDoubleProperty("JMS2_DOUBLE_MIN"));
        Assert.assertEquals((Object)Double.MAX_VALUE, (Object)message.getDoubleProperty("JMS2_DOUBLE_MAX"));
        Assert.assertEquals((Object)Integer.MIN_VALUE, (Object)message.getIntProperty("JMS2_INT_MIN"));
        Assert.assertEquals((Object)Integer.MAX_VALUE, (Object)message.getIntProperty("JMS2_INT_MAX"));
        Assert.assertEquals((Object)Float.valueOf(Float.MIN_VALUE), (Object)Float.valueOf(message.getFloatProperty("JMS2_FLOAT_MIN")));
        Assert.assertEquals((Object)Float.valueOf(Float.MAX_VALUE), (Object)Float.valueOf(message.getFloatProperty("JMS2_FLOAT_MAX")));
        Assert.assertEquals((Object)Long.MIN_VALUE, (Object)message.getLongProperty("JMS2_LONG_MIN"));
        Assert.assertEquals((Object)Long.MAX_VALUE, (Object)message.getLongProperty("JMS2_LONG_MAX"));
        Assert.assertEquals((Object)Short.MIN_VALUE, (Object)message.getShortProperty("JMS2_SHORT_MIN"));
        Assert.assertEquals((Object)Short.MAX_VALUE, (Object)message.getShortProperty("JMS2_SHORT_MAX"));
        Assert.assertEquals((Object)"Hello World", (Object)message.getStringProperty("JMS2_STRING_VAL"));
    }
}

