/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jms2;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.JMSProducer;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.lang.management.ManagementFactory;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.management.JMX;
import javax.management.MBeanServer;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.jmx.BrokerMBeanSupport;
import org.apache.activemq.broker.jmx.DestinationViewMBean;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.broker.jmx.TopicViewMBean;
import org.apache.activemq.command.ActiveMQDestination;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestName;

public abstract class ActiveMQJMS2TestBase {
    public static final String DEFAULT_JMX_DOMAIN_NAME = "org.apache.activemq";
    public static final String DEFAULT_JMX_BROKER_NAME = "localhost";
    public static final String DEFAULT_JMS_USER = "admin";
    public static final String DEFAULT_JMS_PASS = "admin";
    protected static ActiveMQConnectionFactory activemqConnectionFactory = null;
    @Rule
    public TestName testName = new TestName();
    protected Connection connection = null;
    protected Session session = null;
    protected MessageProducer messageProducer = null;
    protected String methodNameDestinationName = null;
    protected MBeanServer mbeanServer = null;

    @BeforeClass
    public static void setUpClass() {
        activemqConnectionFactory = new ActiveMQConnectionFactory("vm://localhost?marshal=false&broker.persistent=false");
        LinkedList<String> newTrustedPackages = new LinkedList<String>();
        newTrustedPackages.addAll(activemqConnectionFactory.getTrustedPackages());
        newTrustedPackages.add(ActiveMQJMS2TestBase.class.getPackageName());
        activemqConnectionFactory.setTrustedPackages(newTrustedPackages);
    }

    @AfterClass
    public static void tearDownClass() {
        activemqConnectionFactory = null;
    }

    @Before
    public void setUp() throws Exception {
        this.connection = activemqConnectionFactory.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
        this.methodNameDestinationName = "AMQ.JMS2." + ActiveMQJMS2TestBase.cleanParameterizedMethodName(this.testName.getMethodName().toUpperCase());
        this.messageProducer = this.session.createProducer((Destination)this.session.createQueue(this.methodNameDestinationName));
        this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void tearDown() {
        if (this.messageProducer != null) {
            try {
                this.messageProducer.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.messageProducer = null;
            }
        }
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.session = null;
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.connection = null;
            }
        }
        this.methodNameDestinationName = null;
    }

    protected DestinationViewMBean getDestinationViewMBean(String destinationType, ActiveMQDestination destination) throws Exception {
        switch (destinationType) {
            case "queue": {
                return this.getQueueViewMBean(destination);
            }
            case "topic": {
                return this.getTopicViewMBean(destination);
            }
            case "temp-queue": {
                return this.getTempQueueViewMBean(destination);
            }
            case "temp-topic": {
                return this.getTempTopicViewMBean(destination);
            }
        }
        throw new IllegalStateException("Unsupported destinationType: " + destinationType);
    }

    protected QueueViewMBean getQueueViewMBean(ActiveMQDestination destination) throws Exception {
        return JMX.newMBeanProxy(this.mbeanServer, BrokerMBeanSupport.createDestinationName((String)BrokerMBeanSupport.createBrokerObjectName((String)DEFAULT_JMX_DOMAIN_NAME, (String)DEFAULT_JMX_BROKER_NAME).toString(), (ActiveMQDestination)destination), QueueViewMBean.class);
    }

    protected TopicViewMBean getTopicViewMBean(ActiveMQDestination destination) throws Exception {
        return JMX.newMBeanProxy(this.mbeanServer, BrokerMBeanSupport.createDestinationName((String)BrokerMBeanSupport.createBrokerObjectName((String)DEFAULT_JMX_DOMAIN_NAME, (String)DEFAULT_JMX_BROKER_NAME).toString(), (ActiveMQDestination)destination), TopicViewMBean.class);
    }

    protected TopicViewMBean getTempQueueViewMBean(ActiveMQDestination destination) throws Exception {
        return JMX.newMBeanProxy(this.mbeanServer, BrokerMBeanSupport.createDestinationName((String)BrokerMBeanSupport.createBrokerObjectName((String)DEFAULT_JMX_DOMAIN_NAME, (String)DEFAULT_JMX_BROKER_NAME).toString(), (ActiveMQDestination)destination), TopicViewMBean.class);
    }

    protected TopicViewMBean getTempTopicViewMBean(ActiveMQDestination destination) throws Exception {
        return JMX.newMBeanProxy(this.mbeanServer, BrokerMBeanSupport.createDestinationName((String)BrokerMBeanSupport.createBrokerObjectName((String)DEFAULT_JMX_DOMAIN_NAME, (String)DEFAULT_JMX_BROKER_NAME).toString(), (ActiveMQDestination)destination), TopicViewMBean.class);
    }

    protected void verifySession(Session session, int acknowledgeMode) throws JMSException {
        try {
            Assert.assertNotNull((Object)session);
            Assert.assertEquals((long)acknowledgeMode, (long)session.getAcknowledgeMode());
            Assert.assertEquals((Object)(acknowledgeMode == 0 ? 1 : 0), (Object)session.getTransacted());
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    protected static String cleanParameterizedMethodName(String methodName) {
        if (methodName == null || !methodName.contains("[") && !methodName.contains("]")) {
            return methodName;
        }
        String[] step1 = methodName.split("\\[", 2);
        String[] step2 = step1[1].split("\\]", 2);
        String[] step3 = step2[0].split(",", 16);
        return step1[0] + "." + step3[0].split("=", 2)[1] + "." + step3[1].split("=", 2)[1];
    }

    protected static void sendMessage(JMSContext jmsContext, Destination testDestination, String textBody) {
        Assert.assertNotNull((Object)jmsContext);
        JMSProducer jmsProducer = jmsContext.createProducer();
        jmsProducer.send(testDestination, textBody);
    }

    protected static void browseMessage(JMSContext jmsContext, Destination testDestination, String expectedTextBody, boolean expectFound) throws JMSException {
        Assert.assertNotNull((Object)jmsContext);
        Assert.assertTrue((boolean)Queue.class.isAssignableFrom(testDestination.getClass()));
        Queue testQueue = (Queue)Queue.class.cast(testDestination);
        try (QueueBrowser queueBrowser = jmsContext.createBrowser(testQueue);){
            Enumeration messageEnumeration = queueBrowser.getEnumeration();
            Assert.assertNotNull((Object)messageEnumeration);
            boolean found = false;
            while (!found && messageEnumeration.hasMoreElements()) {
                Message message = (Message)messageEnumeration.nextElement();
                Assert.assertNotNull((Object)message);
                Assert.assertTrue((boolean)TextMessage.class.isAssignableFrom(message.getClass()));
                Assert.assertEquals((Object)expectedTextBody, (Object)((TextMessage)TextMessage.class.cast(message)).getText());
                found = true;
            }
            Assert.assertEquals((Object)expectFound, (Object)found);
        }
    }

    protected static void recvMessage(JMSContext jmsContext, Destination testDestination, String expectedTextBody) throws JMSException {
        Assert.assertNotNull((Object)jmsContext);
        try (JMSConsumer jmsConsumer = jmsContext.createConsumer(testDestination);){
            Message message = jmsConsumer.receive(1000L);
            Assert.assertNotNull((Object)message);
            Assert.assertTrue((boolean)TextMessage.class.isAssignableFrom(message.getClass()));
            Assert.assertEquals((Object)expectedTextBody, (Object)((TextMessage)TextMessage.class.cast(message)).getText());
        }
    }

    protected static void recvMessageDurable(JMSContext jmsContext, Topic testTopic, String subscriptionName, String selector, boolean noLocal, String expectedTextBody) throws JMSException {
        Assert.assertNotNull((Object)jmsContext);
        try (JMSConsumer jmsConsumer = jmsContext.createDurableConsumer(testTopic, subscriptionName, selector, noLocal);){
            Message message = jmsConsumer.receive(1000L);
            Assert.assertNotNull((Object)message);
            Assert.assertTrue((boolean)TextMessage.class.isAssignableFrom(message.getClass()));
            Assert.assertEquals((Object)expectedTextBody, (Object)((TextMessage)TextMessage.class.cast(message)).getText());
        }
    }
}

