/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.TestCase;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.console.CommandContext;
import org.apache.activemq.console.command.AmqBrowseCommand;
import org.apache.activemq.console.command.DefaultPasswordFactory;
import org.apache.activemq.console.command.LowercasingPasswordFactory;
import org.apache.activemq.console.formatter.CommandShellOutputFormatter;
import org.apache.activemq.console.formatter.OutputFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class AMQ3411Test
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(AMQ3411Test.class);
    private static final Collection<String> DEFAULT_OPTIONS = Arrays.asList("--amqurl", "tcp://localhost:61616");
    private static final Collection<String> DEFAULT_TOKENS = Arrays.asList("FOO.QUEUE");
    protected AbstractApplicationContext context;
    protected static final String origPassword = "ABCDEFG";

    protected void setUp() throws Exception {
        super.setUp();
        this.context = this.createApplicationContext();
    }

    protected AbstractApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/activemq/console/command/activemq.xml");
    }

    protected void tearDown() throws Exception {
        BrokerService broker = (BrokerService)this.context.getBean("localbroker");
        broker.stop();
        broker = (BrokerService)this.context.getBean("default");
        broker.stop();
        super.tearDown();
    }

    public void testNoFactorySet() throws Exception {
        AmqBrowseCommand command = new AmqBrowseCommand();
        CommandContext context = new CommandContext();
        context.setFormatter((OutputFormatter)new CommandShellOutputFormatter((OutputStream)System.out));
        command.setCommandContext(context);
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.addAll(DEFAULT_OPTIONS);
        tokens.addAll(DEFAULT_TOKENS);
        command.execute(tokens);
        AMQ3411Test.assertNotNull((Object)command.getPasswordFactory());
        AMQ3411Test.assertTrue((boolean)(command.getPasswordFactory() instanceof DefaultPasswordFactory));
        AMQ3411Test.assertNull((Object)command.getPassword());
    }

    public void testUsernamePasswordSet() throws Exception {
        AmqBrowseCommand command = new AmqBrowseCommand();
        CommandContext context = new CommandContext();
        String username = "user";
        String password = "password";
        context.setFormatter((OutputFormatter)new CommandShellOutputFormatter((OutputStream)System.out));
        command.setCommandContext(context);
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.addAll(DEFAULT_OPTIONS);
        tokens.add("--password");
        tokens.add(password);
        tokens.add("--user");
        tokens.add(username);
        tokens.addAll(DEFAULT_TOKENS);
        command.execute(tokens);
        AMQ3411Test.assertNotNull((Object)command.getPasswordFactory());
        AMQ3411Test.assertTrue((boolean)(command.getPasswordFactory() instanceof DefaultPasswordFactory));
        AMQ3411Test.assertEquals((String)password, (String)command.getPassword());
        AMQ3411Test.assertEquals((String)username, (String)command.getUsername());
    }

    public void testFactorySet() throws Exception {
        AmqBrowseCommand command = new AmqBrowseCommand();
        CommandContext context = new CommandContext();
        context.setFormatter((OutputFormatter)new CommandShellOutputFormatter((OutputStream)System.out));
        command.setCommandContext(context);
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.addAll(DEFAULT_OPTIONS);
        tokens.add("--passwordFactory");
        tokens.add(LowercasingPasswordFactory.class.getCanonicalName());
        tokens.add("--password");
        tokens.add(origPassword);
        tokens.addAll(DEFAULT_TOKENS);
        command.execute(tokens);
        AMQ3411Test.assertNotNull((Object)command.getPasswordFactory());
        AMQ3411Test.assertTrue((boolean)(command.getPasswordFactory() instanceof LowercasingPasswordFactory));
        AMQ3411Test.assertEquals((String)origPassword.toLowerCase(), (String)command.getPassword());
    }

    public void testFactorySetWrong1() throws Exception {
        AmqBrowseCommand command = new AmqBrowseCommand();
        CommandContext context = new CommandContext();
        context.setFormatter((OutputFormatter)new CommandShellOutputFormatter((OutputStream)System.out));
        command.setCommandContext(context);
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.addAll(DEFAULT_OPTIONS);
        tokens.add("--passwordFactory");
        tokens.add("org.apache.activemq.console.command.TestAMQ3411.DoesntExistFactory");
        tokens.add("--password");
        tokens.add(origPassword);
        tokens.addAll(DEFAULT_TOKENS);
        try {
            command.execute(tokens);
        }
        catch (Throwable e) {
            for (Throwable cause = e; null != cause; cause = cause.getCause()) {
                if (!(cause instanceof ClassNotFoundException)) continue;
                return;
            }
            AMQ3411Test.assertFalse((String)e.toString(), (boolean)true);
        }
        AMQ3411Test.assertFalse((String)"No exception caught", (boolean)true);
    }

    public void testFactorySetWrong2() throws Exception {
        AmqBrowseCommand command = new AmqBrowseCommand();
        CommandContext context = new CommandContext();
        context.setFormatter((OutputFormatter)new CommandShellOutputFormatter((OutputStream)System.out));
        command.setCommandContext(context);
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.addAll(DEFAULT_OPTIONS);
        tokens.add("--passwordFactory");
        tokens.add("java.lang.Object");
        tokens.add("--password");
        tokens.add(origPassword);
        tokens.addAll(DEFAULT_TOKENS);
        try {
            command.execute(tokens);
        }
        catch (Throwable e) {
            for (Throwable cause = e; null != cause; cause = cause.getCause()) {
                if (!(cause instanceof ClassCastException)) continue;
                return;
            }
            AMQ3411Test.assertFalse((String)e.toString(), (boolean)true);
        }
        AMQ3411Test.assertFalse((String)"No exception caught", (boolean)true);
    }
}

